/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jackrabbit.usermanager.impl.resource.AuthorizableValueMap;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;

@Adaptable(adaptableClass=Resource.class, adapters={@Adapter(value={Map.class, ValueMap.class, Authorizable.class}), @Adapter(condition="If the resource is an AuthorizableResource and represents a JCR User", value={User.class}), @Adapter(condition="If the resource is an AuthorizableResource and represents a JCR Group", value={Group.class})})
public class AuthorizableResource
extends AbstractResource {
    private Authorizable authorizable = null;
    private ResourceResolver resourceResolver = null;
    private final String path;
    private final String resourceType;
    private final ResourceMetadata metadata;
    private final SystemUserManagerPaths systemUserManagerPaths;

    public AuthorizableResource(Authorizable authorizable, ResourceResolver resourceResolver, String path, SystemUserManagerPaths systemUserManagerPaths) {
        this.resourceResolver = resourceResolver;
        this.authorizable = authorizable;
        this.path = path;
        this.systemUserManagerPaths = systemUserManagerPaths;
        this.resourceType = authorizable.isGroup() ? "sling/group" : "sling/user";
        this.metadata = new ResourceMetadata();
        this.metadata.setResolutionPath(path);
    }

    public String getPath() {
        return this.path;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getResourceSuperType() {
        return null;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Map.class || type == ValueMap.class) {
            return (AdapterType)new AuthorizableValueMap(this.authorizable, this.systemUserManagerPaths);
        }
        if (type == Authorizable.class || type == User.class && !this.authorizable.isGroup() || type == Group.class && this.authorizable.isGroup()) {
            return (AdapterType)this.authorizable;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        String id = null;
        if (this.authorizable != null) {
            try {
                id = this.authorizable.getID();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + ", id=" + id + ", path=" + this.getPath();
    }
}

