/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.SlingRequestPaths;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.HtmlResponse;
import org.apache.sling.servlets.post.JSONResponse;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.apache.sling.servlets.post.impl.helper.MediaRangeList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPostServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 7408267654653472120L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<PostResponseCreatorHolder> postResponseCreators = new ArrayList<PostResponseCreatorHolder>();
    private PostResponseCreator[] cachedPostResponseCreators = new PostResponseCreator[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse httpResponse) throws ServletException, IOException {
        String redirect;
        PostResponse response = this.createPostResponse(request);
        response.setReferer(request.getHeader("referer"));
        String path = this.getItemPath(request);
        response.setPath(path);
        response.setLocation(this.externalizePath(request, path));
        path = ResourceUtil.getParent((String)path);
        if (path != null) {
            response.setParentLocation(this.externalizePath(request, path));
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        ArrayList<Modification> changes = new ArrayList<Modification>();
        try {
            this.handleOperation(request, response, changes);
            for (Modification change : changes) {
                switch (change.getType()) {
                    case MODIFY: {
                        response.onModified(change.getSource());
                        break;
                    }
                    case DELETE: {
                        response.onDeleted(change.getSource());
                        break;
                    }
                    case MOVE: {
                        response.onMoved(change.getSource(), change.getDestination());
                        break;
                    }
                    case COPY: {
                        response.onCopied(change.getSource(), change.getDestination());
                        break;
                    }
                    case CREATE: {
                        response.onCreated(change.getSource());
                        break;
                    }
                    case ORDER: {
                        response.onChange("ordered", new String[]{change.getSource(), change.getDestination()});
                        break;
                    }
                }
            }
            if (session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (ResourceNotFoundException rnfe) {
            response.setStatus(404, rnfe.getMessage());
        }
        catch (Throwable throwable) {
            this.log.debug("Exception while handling POST " + request.getResource().getPath() + " with " + ((Object)((Object)this)).getClass().getName(), throwable);
            response.setError(throwable);
        }
        finally {
            try {
                if (session.hasPendingChanges()) {
                    session.refresh(false);
                }
            }
            catch (RepositoryException e) {
                this.log.warn("RepositoryException in finally block: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (response.isSuccessful() && (redirect = this.getRedirectUrl((HttpServletRequest)request, response)) != null) {
            httpResponse.sendRedirect(redirect);
            return;
        }
        response.send((HttpServletResponse)httpResponse, this.isSetStatus(request));
    }

    @Deprecated
    protected AbstractPostResponse createHtmlResponse(SlingHttpServletRequest req) {
        return (AbstractPostResponse)this.createPostResponse(req);
    }

    PostResponse createPostResponse(SlingHttpServletRequest req) {
        String headerValue;
        for (PostResponseCreator creator : this.cachedPostResponseCreators) {
            PostResponse response = creator.createPostResponse(req);
            if (response == null) continue;
            return response;
        }
        MediaRangeList mediaRangeList = null;
        String queryParam = req.getParameter(":http-equiv-accept");
        if (!(queryParam != null && queryParam.trim().length() != 0 || (headerValue = req.getHeader("Accept")) != null && headerValue.trim().length() != 0)) {
            mediaRangeList = new MediaRangeList(req.getResponseContentType());
        }
        if (mediaRangeList == null) {
            mediaRangeList = new MediaRangeList((HttpServletRequest)req);
        }
        if ("application/json".equals(mediaRangeList.prefer("text/html", "application/json"))) {
            return new JSONResponse();
        }
        return new HtmlResponse();
    }

    @Deprecated
    protected void handleOperation(SlingHttpServletRequest request, AbstractPostResponse response, List<Modification> changes) throws RepositoryException {
        this.handleOperation(request, (PostResponse)response, changes);
    }

    protected abstract void handleOperation(SlingHttpServletRequest var1, PostResponse var2, List<Modification> var3) throws RepositoryException;

    @Deprecated
    protected String getRedirectUrl(HttpServletRequest request, AbstractPostResponse ctx) {
        return this.getRedirectUrl(request, (PostResponse)ctx);
    }

    protected String getRedirectUrl(HttpServletRequest request, PostResponse ctx) {
        String result = request.getParameter(":redirect");
        if (result != null) {
            try {
                URI redirectUri = new URI(result);
                if (redirectUri.getAuthority() != null) {
                    this.log.warn("redirect target ({}) does include host information ({}). This is not allowed for security reasons!", (Object)result, (Object)redirectUri.getAuthority());
                    return null;
                }
            }
            catch (URISyntaxException e) {
                this.log.warn("given redirect target ({}) is not a valid uri: {}", (Object)result, (Object)e);
                return null;
            }
            this.log.debug("redirect requested as [{}] for path [{}]", (Object)result, (Object)ctx.getPath());
            if (ctx.getPath() != null) {
                int star = result.indexOf(42);
                if (star >= 0) {
                    StringBuffer buf = new StringBuffer();
                    if (star > 0) {
                        buf.append(result.substring(0, star));
                    }
                    buf.append(ResourceUtil.getName((String)ctx.getPath()));
                    if (star < result.length() - 1) {
                        buf.append(result.substring(star + 1));
                    }
                    result = buf.toString();
                } else if (result.endsWith("/")) {
                    result = result.concat(ResourceUtil.getName((String)ctx.getPath()));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Will redirect to " + result);
                }
            }
        }
        return result;
    }

    protected boolean isSetStatus(SlingHttpServletRequest request) {
        String statusParam = request.getParameter(":status");
        if (statusParam == null) {
            this.log.debug("getStatusMode: Parameter {} not set, assuming standard status code", (Object)":status");
            return true;
        }
        if ("browser".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for user-friendly status code", (Object)":status");
            return false;
        }
        if ("standard".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for standard status code", (Object)":status");
            return true;
        }
        this.log.debug("getStatusMode: Parameter {} set to unknown value {}, assuming standard status code", (Object)":status");
        return true;
    }

    protected String getItemPath(SlingHttpServletRequest request) {
        return request.getResource().getPath();
    }

    protected final String externalizePath(SlingHttpServletRequest request, String path) {
        StringBuffer ret = new StringBuffer();
        ret.append(SlingRequestPaths.getContextPath((HttpServletRequest)request));
        ret.append(request.getResourceResolver().map(path));
        String ext = request.getParameter(":displayExtension");
        if (ext != null && ext.length() > 0) {
            if (ext.charAt(0) != '.') {
                ret.append('.');
            }
            ret.append(ext);
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        PostResponseCreatorHolder nngh = new PostResponseCreatorHolder(creator, this.getRanking(properties));
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            int index;
            for (index = 0; index < this.postResponseCreators.size() && nngh.getRanking() < this.postResponseCreators.get(index).getRanking(); ++index) {
            }
            if (index == this.postResponseCreators.size()) {
                this.postResponseCreators.add(nngh);
            } else {
                this.postResponseCreators.add(index, nngh);
            }
            this.updatePostResponseCreatorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            Iterator<PostResponseCreatorHolder> i = this.postResponseCreators.iterator();
            while (i.hasNext()) {
                PostResponseCreatorHolder current = i.next();
                if (current.getCreator() != creator) continue;
                i.remove();
            }
            this.updatePostResponseCreatorCache();
        }
    }

    private void updatePostResponseCreatorCache() {
        PostResponseCreator[] localCache = new PostResponseCreator[this.postResponseCreators.size()];
        int index = 0;
        for (PostResponseCreatorHolder current : this.postResponseCreators) {
            localCache[index] = current.creator;
            ++index;
        }
        this.cachedPostResponseCreators = localCache;
    }

    private int getRanking(Map<String, Object> properties) {
        Object val = properties.get("service.ranking");
        return val instanceof Integer ? (Integer)val : 0;
    }

    private static final class PostResponseCreatorHolder {
        private final PostResponseCreator creator;
        private final int ranking;

        public PostResponseCreatorHolder(PostResponseCreator creator, int ranking) {
            this.creator = creator;
            this.ranking = ranking;
        }

        public PostResponseCreator getCreator() {
            return this.creator;
        }

        public int getRanking() {
            return this.ranking;
        }
    }
}

