/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jackrabbit.usermanager.AuthorizablePrivilegesInfo;
import org.apache.sling.jackrabbit.usermanager.ChangeUserPassword;
import org.apache.sling.jackrabbit.usermanager.CreateUser;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AuthorizablePrivilegesInfo.class}, property={"user.admin.group.name=UserAdmin", "group.admin.group.name=GroupAdmin"})
public class AuthorizablePrivilegesInfoImpl
implements AuthorizablePrivilegesInfo {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    static final String DEFAULT_USER_ADMIN_GROUP_NAME = "UserAdmin";
    static final String PAR_USER_ADMIN_GROUP_NAME = "user.admin.group.name";
    static final String DEFAULT_GROUP_ADMIN_GROUP_NAME = "GroupAdmin";
    static final String PAR_GROUP_ADMIN_GROUP_NAME = "group.admin.group.name";
    private String usersPath;
    private String groupsPath;
    private boolean selfRegistrationEnabled;
    private boolean alwaysAllowSelfChangePassword = false;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private void bindChangeUserPassword(ChangeUserPassword changeUserPassword, Map<String, Object> properties) {
        this.alwaysAllowSelfChangePassword = OsgiUtil.toBoolean((Object)properties.get("alwaysAllowSelfChangePassword"), (boolean)false);
    }

    private void unbindChangeUserPassword(ChangeUserPassword changeUserPassword, Map<String, Object> properties) {
        this.alwaysAllowSelfChangePassword = false;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private void bindUserConfiguration(UserConfiguration userConfig, Map<String, Object> properties) {
        this.usersPath = (String)properties.get("usersPath");
        this.groupsPath = (String)properties.get("groupsPath");
    }

    private void unbindUserConfiguration(UserConfiguration userConfig, Map<String, Object> properties) {
        this.usersPath = null;
        this.groupsPath = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private void bindCreateUser(CreateUser createUser, Map<String, Object> properties) {
        this.selfRegistrationEnabled = Boolean.TRUE.equals(properties.get("self.registration.enabled"));
    }

    private void unbindCreateUser(CreateUser createUser, Map<String, Object> properties) {
        this.selfRegistrationEnabled = false;
    }

    @Override
    public boolean canAddGroup(Session jcrSession) {
        boolean hasRights = false;
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (currentUser instanceof User && ((User)currentUser).isAdmin()) {
                hasRights = true;
            } else if (this.groupsPath != null) {
                AccessControlManager acm = jcrSession.getAccessControlManager();
                hasRights = acm.hasPrivileges(this.groupsPath, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl"), acm.privilegeFromName("rep:write"), acm.privilegeFromName("rep:userManagement")});
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can add a new group", (Object)jcrSession.getUserID());
        }
        return hasRights;
    }

    @Override
    public boolean canAddUser(Session jcrSession) {
        boolean hasRights = false;
        try {
            if (this.selfRegistrationEnabled) {
                hasRights = true;
            } else {
                UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
                Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
                if (currentUser instanceof User && ((User)currentUser).isAdmin()) {
                    hasRights = true;
                } else if (this.usersPath != null) {
                    AccessControlManager acm = jcrSession.getAccessControlManager();
                    hasRights = acm.hasPrivileges(this.usersPath, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl"), acm.privilegeFromName("rep:write"), acm.privilegeFromName("rep:userManagement")});
                }
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can add a new user", (Object)jcrSession.getUserID());
        }
        return hasRights;
    }

    @Override
    public boolean canRemove(Session jcrSession, String principalId) {
        boolean hasRights = false;
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (currentUser instanceof User && ((User)currentUser).isAdmin()) {
                hasRights = true;
            } else {
                Authorizable authorizable = userManager.getAuthorizable(principalId);
                if (authorizable == null) {
                    this.log.debug("Failed to find authorizable: {}", (Object)principalId);
                } else {
                    String path = authorizable.getPath();
                    if (path != null) {
                        AccessControlManager acm = jcrSession.getAccessControlManager();
                        hasRights = acm.hasPrivileges(path, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("rep:userManagement")});
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can remove authorizable {}", (Object)jcrSession.getUserID(), (Object)principalId);
        }
        return hasRights;
    }

    @Override
    public boolean canUpdateGroupMembers(Session jcrSession, String groupId) {
        boolean hasRights = false;
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (currentUser instanceof User && ((User)currentUser).isAdmin()) {
                hasRights = true;
            } else {
                Authorizable authorizable = userManager.getAuthorizable(groupId);
                if (authorizable == null) {
                    this.log.debug("Failed to find group: {}", (Object)groupId);
                } else {
                    String path = authorizable.getPath();
                    if (path != null) {
                        AccessControlManager acm = jcrSession.getAccessControlManager();
                        hasRights = acm.hasPrivileges(path, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("rep:userManagement")});
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can remove authorizable {}", (Object)jcrSession.getUserID(), (Object)groupId);
        }
        return hasRights;
    }

    @Override
    public boolean canUpdateProperties(Session jcrSession, String principalId) {
        return this.canUpdateProperties(jcrSession, principalId, AuthorizablePrivilegesInfo.PropertyUpdateTypes.addProperty, AuthorizablePrivilegesInfo.PropertyUpdateTypes.addNestedProperty, AuthorizablePrivilegesInfo.PropertyUpdateTypes.alterProperty, AuthorizablePrivilegesInfo.PropertyUpdateTypes.removeProperty);
    }

    @Override
    public boolean canUpdateProperties(Session jcrSession, String principalId, AuthorizablePrivilegesInfo.PropertyUpdateTypes ... propertyUpdateTypes) {
        boolean hasRights = false;
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (currentUser instanceof User && ((User)currentUser).isAdmin()) {
                hasRights = true;
            } else {
                Authorizable authorizable = userManager.getAuthorizable(principalId);
                if (authorizable == null) {
                    this.log.debug("Failed to find authorizable: {}", (Object)principalId);
                } else {
                    String path = authorizable.getPath();
                    if (path != null) {
                        AccessControlManager acm = jcrSession.getAccessControlManager();
                        HashSet<Privilege> requiredPrivileges = new HashSet<Privilege>();
                        requiredPrivileges.add(acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"));
                        if (propertyUpdateTypes != null) {
                            block8: for (AuthorizablePrivilegesInfo.PropertyUpdateTypes updateType : propertyUpdateTypes) {
                                switch (updateType) {
                                    case addNestedProperty: {
                                        requiredPrivileges.add(acm.privilegeFromName("rep:addProperties"));
                                        requiredPrivileges.add(acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes"));
                                        continue block8;
                                    }
                                    case addProperty: {
                                        requiredPrivileges.add(acm.privilegeFromName("rep:addProperties"));
                                        continue block8;
                                    }
                                    case alterProperty: {
                                        requiredPrivileges.add(acm.privilegeFromName("rep:alterProperties"));
                                        continue block8;
                                    }
                                    case removeProperty: {
                                        requiredPrivileges.add(acm.privilegeFromName("rep:removeProperties"));
                                        continue block8;
                                    }
                                    default: {
                                        this.log.warn("Unexpected property update type: {}", (Object)updateType);
                                    }
                                }
                            }
                        }
                        hasRights = acm.hasPrivileges(path, requiredPrivileges.toArray(new Privilege[requiredPrivileges.size()]));
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can update properties of authorizable {}", (Object)jcrSession.getUserID(), (Object)principalId);
        }
        return hasRights;
    }

    @Override
    public boolean canDisable(Session jcrSession, String userId) {
        boolean hasRights = false;
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (currentUser instanceof User && ((User)currentUser).isAdmin()) {
                hasRights = true;
            } else {
                Authorizable authorizable = userManager.getAuthorizable(userId);
                if (!(authorizable instanceof User)) {
                    this.log.debug("Failed to find user: {}", (Object)userId);
                } else {
                    String path = authorizable.getPath();
                    if (path != null) {
                        AccessControlManager acm = jcrSession.getAccessControlManager();
                        HashSet<Privilege> requiredPrivileges = new HashSet<Privilege>();
                        requiredPrivileges.add(acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"));
                        requiredPrivileges.add(acm.privilegeFromName("rep:userManagement"));
                        hasRights = acm.hasPrivileges(path, requiredPrivileges.toArray(new Privilege[requiredPrivileges.size()]));
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can disable user {}", (Object)jcrSession.getUserID(), (Object)userId);
        }
        return hasRights;
    }

    @Override
    public boolean canChangePassword(Session jcrSession, String userId) {
        boolean hasRights = false;
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            Authorizable authorizable = userManager.getAuthorizable(userId);
            if (!(authorizable instanceof User)) {
                this.log.debug("Failed to find user: {}", (Object)userId);
            } else if (((User)authorizable).isSystemUser() || "anonymous".equals(authorizable.getID())) {
                hasRights = false;
            } else if (currentUser instanceof User && ((User)currentUser).isAdmin()) {
                hasRights = true;
            } else {
                String path = authorizable.getPath();
                if (path != null) {
                    AccessControlManager acm = jcrSession.getAccessControlManager();
                    HashSet<Privilege> requiredPrivileges = new HashSet<Privilege>();
                    requiredPrivileges.add(acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"));
                    requiredPrivileges.add(acm.privilegeFromName("rep:userManagement"));
                    hasRights = acm.hasPrivileges(path, requiredPrivileges.toArray(new Privilege[requiredPrivileges.size()]));
                }
                if (!hasRights && jcrSession.getUserID().equals(userId)) {
                    hasRights = this.alwaysAllowSelfChangePassword;
                }
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can change the password of user {}", (Object)jcrSession.getUserID(), (Object)userId);
        }
        return hasRights;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        String groupAdminGroupName;
        String userAdminGroupName = OsgiUtil.toString((Object)properties.get(PAR_USER_ADMIN_GROUP_NAME), null);
        if (userAdminGroupName != null && !DEFAULT_USER_ADMIN_GROUP_NAME.equals(userAdminGroupName)) {
            this.log.warn("Configuration setting for {} is deprecated and will not have any effect", (Object)PAR_USER_ADMIN_GROUP_NAME);
        }
        if ((groupAdminGroupName = OsgiUtil.toString((Object)properties.get(PAR_GROUP_ADMIN_GROUP_NAME), null)) != null && !DEFAULT_GROUP_ADMIN_GROUP_NAME.equals(userAdminGroupName)) {
            this.log.warn("Configuration setting for {} is deprecated and will not have any effect", (Object)PAR_GROUP_ADMIN_GROUP_NAME);
        }
    }
}

