/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalPrivilege;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalRestriction;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.JsonConvert;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.PrivilegesHelper;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessGetServlet;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.DeclarationType;

public abstract class AbstractGetAclServlet
extends AbstractAccessGetServlet {
    @Deprecated
    protected static final String KEY_ORDER = "order";
    @Deprecated
    protected static final String KEY_DENIED = "denied";
    @Deprecated
    protected static final String KEY_GRANTED = "granted";

    @Override
    protected JsonObject internalJson(Session session, String resourcePath, String principalId) throws RepositoryException {
        return this.internalGetAcl(session, resourcePath);
    }

    protected JsonObject internalGetAcl(Session jcrSession, String resourcePath) throws RepositoryException {
        this.validateArgs(jcrSession, resourcePath);
        Set supportedRestrictions = this.getRestrictionProvider().getSupportedRestrictions(resourcePath);
        HashMap<String, RestrictionDefinition> srMap = new HashMap<String, RestrictionDefinition>();
        for (RestrictionDefinition restrictionDefinition : supportedRestrictions) {
            srMap.put(restrictionDefinition.getName(), restrictionDefinition);
        }
        HashMap<Principal, Map<DeclarationType, Set<String>>> principalToDeclaredAtPaths = new HashMap<Principal, Map<DeclarationType, Set<String>>>();
        Map<String, List<AccessControlEntry>> effectivePathToEntriesMap = this.getAccessControlEntriesMap(jcrSession, resourcePath, principalToDeclaredAtPaths);
        HashMap<Principal, Integer> principalToOrderMap = new HashMap<Principal, Integer>();
        HashMap<Principal, Map> principalToPrivilegesMap = new HashMap<Principal, Map>();
        for (Map.Entry<String, List<AccessControlEntry>> entry : effectivePathToEntriesMap.entrySet()) {
            List<AccessControlEntry> accessControlEntries = entry.getValue();
            Iterator<AccessControlEntry> iterator = accessControlEntries.iterator();
            while (iterator.hasNext()) {
                JackrabbitAccessControlEntry jrAccessControlEntry;
                Privilege[] privileges;
                AccessControlEntry accessControlEntry = iterator.next();
                if (!(accessControlEntry instanceof JackrabbitAccessControlEntry) || (privileges = (jrAccessControlEntry = (JackrabbitAccessControlEntry)accessControlEntry).getPrivileges()) == null) continue;
                Principal principal = accessControlEntry.getPrincipal();
                if (!principalToPrivilegesMap.containsKey(principal)) {
                    principalToOrderMap.put(principal, principalToPrivilegesMap.size());
                }
                Map map = principalToPrivilegesMap.computeIfAbsent(principal, k -> new HashMap());
                this.processACE(srMap, jrAccessControlEntry, privileges, map);
            }
        }
        AccessControlManager acm = AccessControlUtil.getAccessControlManager((Session)jcrSession);
        Map<Privilege, Integer> privilegeLongestDepthMap = PrivilegesHelper.buildPrivilegeLongestDepthMap(acm.privilegeFromName("jcr:all"));
        for (Map.Entry entry : principalToPrivilegesMap.entrySet()) {
            Map privilegeToLocalPrivilegesMap = (Map)entry.getValue();
            PrivilegesHelper.consolidateAggregates(jcrSession, resourcePath, privilegeToLocalPrivilegesMap, privilegeLongestDepthMap);
        }
        ArrayList<Map.Entry<Principal, Map<Privilege, LocalPrivilege>>> entrySetList = new ArrayList<Map.Entry<Principal, Map<Privilege, LocalPrivilege>>>(principalToPrivilegesMap.entrySet());
        Collections.sort(entrySetList, (e1, e2) -> ((Integer)principalToOrderMap.get(e1.getKey())).compareTo((Integer)principalToOrderMap.get(e2.getKey())));
        JsonObjectBuilder jsonObjectBuilder = this.convertToJson(entrySetList, principalToDeclaredAtPaths);
        return jsonObjectBuilder.build();
    }

    protected JsonObjectBuilder convertToJson(List<Map.Entry<Principal, Map<Privilege, LocalPrivilege>>> entrySetList, Map<Principal, Map<DeclarationType, Set<String>>> declaredAtPaths) {
        JsonObjectBuilder jsonObj = Json.createObjectBuilder();
        for (int i = 0; i < entrySetList.size(); ++i) {
            Map.Entry<Principal, Map<Privilege, LocalPrivilege>> entry = entrySetList.get(i);
            Principal principal = entry.getKey();
            JsonObjectBuilder principalObj = JsonConvert.convertToJson(entry.getKey(), entry.getValue(), i);
            this.addExtraInfo(principalObj, principal, declaredAtPaths);
            jsonObj.add(principal.getName(), principalObj);
        }
        return jsonObj;
    }

    protected void addExtraInfo(JsonObjectBuilder principalJson, Principal principal, Map<Principal, Map<DeclarationType, Set<String>>> principalToDeclaredAtPaths) {
    }

    @Deprecated
    protected void addRestrictions(JsonObjectBuilder privilegeObj, String key, Set<LocalRestriction> restrictions) {
        JsonConvert.addRestrictions(privilegeObj, key, restrictions);
    }

    @Deprecated
    protected JsonObjectBuilder addTo(JsonObjectBuilder builder, String key, Object value) {
        return JsonConvert.addTo(builder, key, value);
    }

    @Deprecated
    protected JsonArrayBuilder addTo(JsonArrayBuilder builder, Object value) {
        return JsonConvert.addTo(builder, value);
    }

    protected abstract Map<String, List<AccessControlEntry>> getAccessControlEntriesMap(Session var1, String var2, Map<Principal, Map<DeclarationType, Set<String>>> var3) throws RepositoryException;

    @Deprecated
    protected AccessControlEntry[] getAccessControlEntries(Session session, String absPath) throws RepositoryException {
        return (AccessControlEntry[])this.getAccessControlEntriesMap(session, absPath, new HashMap<Principal, Map<DeclarationType, Set<String>>>()).values().stream().toArray(AccessControlEntry[]::new);
    }
}

