/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.servlet.Servlet;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetEffectiveAcl;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.JsonConvert;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractGetAclServlet;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.DeclarationType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class, GetEffectiveAcl.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET", "sling.servlet.selectors=eacl", "sling.servlet.selectors=tidy.eacl", "sling.servlet.extensions=json", "sling.servlet.prefix:Integer=-1"}, reference={@Reference(name="RestrictionProvider", bind="bindRestrictionProvider", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=RestrictionProvider.class)})
public class GetEffectiveAclServlet
extends AbstractGetAclServlet
implements GetEffectiveAcl {
    private static final long serialVersionUID = 1929547523002363145L;

    @Override
    public JsonObject getEffectiveAcl(Session jcrSession, String resourcePath) throws RepositoryException {
        return this.internalGetAcl(jcrSession, resourcePath);
    }

    @Override
    protected void addExtraInfo(JsonObjectBuilder principalJson, Principal principal, Map<Principal, Map<DeclarationType, Set<String>>> principalToDeclaredAtPaths) {
        Map<DeclarationType, Set<String>> map = principalToDeclaredAtPaths.get(principal);
        JsonConvert.addDeclaredAt(principalJson, map);
    }

    @Override
    protected Map<String, List<AccessControlEntry>> getAccessControlEntriesMap(Session session, String absPath, Map<Principal, Map<DeclarationType, Set<String>>> declaredAtPaths) throws RepositoryException {
        AccessControlManager accessControlManager = session.getAccessControlManager();
        AccessControlPolicy[] policies = accessControlManager.getEffectivePolicies(absPath);
        return this.entriesSortedByEffectivePath(policies, ace -> true, declaredAtPaths);
    }
}

