/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetAcl;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetEffectiveAcl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegesInfo {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Privilege[] getSupportedPrivileges(Node node) throws RepositoryException {
        return this.getSupportedPrivileges(node.getSession(), node.getPath());
    }

    public Privilege[] getSupportedPrivileges(Session session, String absPath) throws RepositoryException {
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        return accessControlManager.getSupportedPrivileges(absPath);
    }

    public Map<Principal, AccessRights> getDeclaredAccessRights(Node node) throws RepositoryException {
        return this.getDeclaredAccessRights(node.getSession(), node.getPath());
    }

    public Map<Principal, AccessRights> getDeclaredAccessRights(Session session, String absPath) throws RepositoryException {
        return this.toMap(session, PrivilegesInfo.useGetAcl(json -> {
            try {
                return json.getAcl(session, absPath);
            }
            catch (RepositoryException e) {
                this.logger.warn("Failed to load Acl", (Throwable)e);
                return null;
            }
        }));
    }

    protected Map<Principal, AccessRights> toMap(Session session, JsonObject aclJson) throws RepositoryException {
        if (aclJson == null) {
            return Collections.emptyMap();
        }
        AccessControlManager acm = session.getAccessControlManager();
        PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
        Function<JsonValue, Principal> keyMapper = val -> {
            String principalId = ((JsonObject)val).getString("principal");
            return principalManager.getPrincipal(principalId);
        };
        Function<JsonValue, AccessRights> valueMapper = val -> {
            AccessRights rights = new AccessRights();
            JsonObject privilegesObj = ((JsonObject)val).getJsonObject("privileges");
            if (privilegesObj != null) {
                privilegesObj.entrySet().stream().forEach(entry -> {
                    JsonValue value;
                    Privilege privilege = null;
                    try {
                        privilege = acm.privilegeFromName((String)entry.getKey());
                    }
                    catch (RepositoryException e) {
                        this.logger.warn("Failed to resolve privilege", (Throwable)e);
                    }
                    if (privilege != null && (value = (JsonValue)entry.getValue()) instanceof JsonObject) {
                        JsonObject privilegeObj = (JsonObject)value;
                        if (privilegeObj.containsKey((Object)"allow")) {
                            rights.granted.add(privilege);
                        }
                        if (privilegeObj.containsKey((Object)"deny")) {
                            rights.denied.add(privilege);
                        }
                    }
                });
            }
            return rights;
        };
        Map<Principal, AccessRights> map = aclJson.values().stream().collect(Collectors.toMap(keyMapper, valueMapper));
        return map;
    }

    public AccessRights getDeclaredAccessRightsForPrincipal(Node node, String principalId) throws RepositoryException {
        return this.getDeclaredAccessRightsForPrincipal(node.getSession(), node.getPath(), principalId);
    }

    public AccessRights getDeclaredAccessRightsForPrincipal(Session session, String absPath, String principalId) throws RepositoryException {
        Map<Principal, AccessRights> declaredAccessRights = this.getDeclaredAccessRights(session, absPath);
        PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
        Principal principal = principalManager.getPrincipal(principalId);
        return declaredAccessRights.get(principal);
    }

    @Deprecated
    public Map<String, Object> getDeclaredRestrictionsForPrincipal(Node node, String principalId) throws RepositoryException {
        return this.getDeclaredRestrictionsForPrincipal(node.getSession(), node.getPath(), principalId);
    }

    @Deprecated
    public Map<String, Object> getDeclaredRestrictionsForPrincipal(Session session, String absPath, String principalId) throws RepositoryException {
        Map<String, Object> map;
        JsonObject aclJson = PrivilegesInfo.useGetAcl(json -> {
            try {
                return json.getAcl(session, absPath);
            }
            catch (RepositoryException e) {
                this.logger.warn("Failed to load Acl", (Throwable)e);
                return null;
            }
        });
        if (aclJson == null) {
            map = Collections.emptyMap();
        } else {
            HashMap srMap = new HashMap();
            PrivilegesInfo.useRestrictionProvider(restrictionProvider -> {
                Set supportedRestrictions = restrictionProvider.getSupportedRestrictions(absPath);
                for (RestrictionDefinition restrictionDefinition : supportedRestrictions) {
                    srMap.put(restrictionDefinition.getName(), restrictionDefinition);
                }
                return null;
            });
            ValueFactory valueFactory = session.getValueFactory();
            map = new HashMap<String, Object>();
            aclJson.values().stream().filter(val -> val instanceof JsonObject && ((JsonObject)val).getString("principal").equals(principalId)).forEach(item -> {
                JsonObject privilegesObj = ((JsonObject)item).getJsonObject("privileges");
                if (privilegesObj != null) {
                    privilegesObj.values().forEach(privItem -> {
                        JsonObject privilegeObj;
                        JsonValue jsonValue;
                        if (privItem instanceof JsonObject && (jsonValue = (JsonValue)(privilegeObj = (JsonObject)privItem).get((Object)"allow")) instanceof JsonObject) {
                            JsonObject restriction = (JsonObject)jsonValue;
                            restriction.entrySet().stream().forEach(restrictionItem -> {
                                String restrictionName = (String)restrictionItem.getKey();
                                int type = ((RestrictionDefinition)srMap.get(restrictionName)).getRequiredType().tag();
                                JsonValue value = (JsonValue)restrictionItem.getValue();
                                if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
                                    JsonArray jsonArray = (JsonArray)value;
                                    Value[] restrictionValues = new Value[jsonArray.size()];
                                    for (int i = 0; i < jsonArray.size(); ++i) {
                                        try {
                                            restrictionValues[i] = valueFactory.createValue(jsonArray.getString(i), type);
                                            continue;
                                        }
                                        catch (ValueFormatException e) {
                                            this.logger.warn("Failed to create restriction value", (Throwable)e);
                                        }
                                    }
                                    map.put(restrictionName, restrictionValues);
                                } else if (value instanceof JsonString) {
                                    try {
                                        Value restrictionValue = valueFactory.createValue(((JsonString)value).getString(), type);
                                        map.put(restrictionName, restrictionValue);
                                    }
                                    catch (ValueFormatException e) {
                                        this.logger.warn("Failed to create restriction value", (Throwable)e);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
        return map;
    }

    public Map<Principal, AccessRights> getEffectiveAccessRights(Node node) throws RepositoryException {
        return this.getEffectiveAccessRights(node.getSession(), node.getPath());
    }

    public Map<Principal, AccessRights> getEffectiveAccessRights(Session session, String absPath) throws RepositoryException {
        return this.toMap(session, PrivilegesInfo.useGetEffectiveAcl(json -> {
            try {
                return json.getEffectiveAcl(session, absPath);
            }
            catch (RepositoryException e) {
                this.logger.warn("Failed to load EffectiveAcl", (Throwable)e);
                return null;
            }
        }));
    }

    public AccessRights getEffectiveAccessRightsForPrincipal(Node node, String principalId) throws RepositoryException {
        return this.getEffectiveAccessRightsForPrincipal(node.getSession(), node.getPath(), principalId);
    }

    public AccessRights getEffectiveAccessRightsForPrincipal(Session session, String absPath, String principalId) throws RepositoryException {
        Map<Principal, AccessRights> effectiveAccessRights = this.getEffectiveAccessRights(session, absPath);
        PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
        Principal principal = principalManager.getPrincipal(principalId);
        return effectiveAccessRights.get(principal);
    }

    public boolean canAddChildren(Node node) {
        try {
            return this.canAddChildren(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canAddChildren(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canDeleteChildren(Node node) {
        try {
            return this.canDeleteChildren(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canDeleteChildren(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canDelete(Node node) {
        try {
            return this.canDelete(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canDelete(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            int lastSlash = absPath.lastIndexOf(47);
            String parentPath = lastSlash == 0 ? "/" : absPath.substring(0, lastSlash);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode")}) && this.canDeleteChildren(session, parentPath);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canModifyProperties(Node node) {
        try {
            return this.canModifyProperties(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canModifyProperties(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canReadAccessControl(Node node) {
        try {
            return this.canReadAccessControl(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canReadAccessControl(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canModifyAccessControl(Node node) {
        try {
            return this.canModifyAccessControl(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canModifyAccessControl(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S, T> T useSvc(Class<S> svc, Function<S, T> fn) {
        ServiceReference serviceReference;
        BundleContext bundleContext;
        T value = null;
        Bundle bundle = FrameworkUtil.getBundle(PrivilegesInfo.class);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null && (serviceReference = bundleContext.getServiceReference(svc)) != null) {
            Object service = null;
            try {
                service = bundleContext.getService(serviceReference);
                if (service != null) {
                    value = fn.apply(service);
                }
            }
            finally {
                if (service != null) {
                    bundleContext.ungetService(serviceReference);
                }
            }
        }
        return value;
    }

    private static <T> T useGetAcl(Function<GetAcl, T> fn) {
        return PrivilegesInfo.useSvc(GetAcl.class, fn);
    }

    private static <T> T useGetEffectiveAcl(Function<GetEffectiveAcl, T> fn) {
        return PrivilegesInfo.useSvc(GetEffectiveAcl.class, fn);
    }

    private static <T> T useRestrictionProvider(Function<RestrictionProvider, T> fn) {
        return PrivilegesInfo.useSvc(RestrictionProvider.class, fn);
    }

    public static class AccessRights {
        private Set<Privilege> granted = new HashSet<Privilege>();
        private Set<Privilege> denied = new HashSet<Privilege>();
        private ResourceBundle resBundle = null;

        private ResourceBundle getResourceBundle(Locale locale) {
            if (this.resBundle == null || !this.resBundle.getLocale().equals(locale)) {
                this.resBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".PrivilegesResources", locale);
            }
            return this.resBundle;
        }

        public Set<Privilege> getGranted() {
            return this.granted;
        }

        public Set<Privilege> getDenied() {
            return this.denied;
        }

        public String getPrivilegeSetDisplayName(Locale locale) {
            if (this.denied != null && !this.denied.isEmpty()) {
                return this.getResourceBundle(locale).getString("privilegeset.custom");
            }
            if (this.granted.isEmpty()) {
                return this.getResourceBundle(locale).getString("privilegeset.none");
            }
            if (this.granted.size() == 1) {
                Iterator<Privilege> iterator = this.granted.iterator();
                Privilege next = iterator.next();
                if ("jcr:all".equals(next.getName())) {
                    return this.getResourceBundle(locale).getString("privilegeset.all");
                }
                if ("jcr:read".equals(next.getName())) {
                    return this.getResourceBundle(locale).getString("privilegeset.readonly");
                }
            } else if (this.granted.size() == 2) {
                Iterator<Privilege> iterator = this.granted.iterator();
                Privilege next = iterator.next();
                Privilege next2 = iterator.next();
                if ("jcr:read".equals(next.getName()) && "jcr:write".equals(next2.getName()) || "jcr:read".equals(next2.getName()) && "jcr:write".equals(next.getName())) {
                    return this.getResourceBundle(locale).getString("privilegeset.readwrite");
                }
            }
            return this.getResourceBundle(locale).getString("privilegeset.custom");
        }
    }
}

