/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.ModifyAce;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessPostServlet;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class, ModifyAce.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=POST", "sling.servlet.selectors=modifyAce"})
public class ModifyAceServlet
extends AbstractAccessPostServlet
implements ModifyAce {
    private static final long serialVersionUID = -9182485466670280437L;
    private RestrictionProvider restrictionProvider = null;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindRestrictionProvider(RestrictionProvider rp) {
        this.restrictionProvider = rp;
    }

    protected void unbindRestrictionProvider(RestrictionProvider rp) {
        this.restrictionProvider = null;
    }

    @Override
    @Reference(service=PostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.bindPostResponseCreator(creator, properties);
    }

    @Override
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.unbindPostResponseCreator(creator, properties);
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String resourcePath = request.getResource().getPath();
        String principalId = request.getParameter("principalId");
        HashMap<String, String> privileges = new HashMap<String, String>();
        HashMap<String, Value> restrictions = new HashMap<String, Value>();
        HashMap<String, Value[]> mvRestrictions = new HashMap<String, Value[]>();
        HashSet<String> removeRestrictionNames = new HashSet<String>();
        HashMap<String, RestrictionDefinition> supportedRestrictionsMap = null;
        ValueFactory factory = session.getValueFactory();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            Value v;
            String restrictionName;
            Object nextElement = parameterNames.nextElement();
            if (!(nextElement instanceof String)) continue;
            String paramName = (String)nextElement;
            if (paramName.startsWith("privilege@")) {
                String privilegeName = paramName.substring(10);
                String parameterValue = request.getParameter(paramName);
                privileges.put(privilegeName, parameterValue);
                continue;
            }
            if (!paramName.startsWith("restriction@")) continue;
            if (this.restrictionProvider == null) {
                throw new IllegalArgumentException("No restriction provider is available so unable to process POSTed restriction values");
            }
            if (supportedRestrictionsMap == null) {
                supportedRestrictionsMap = new HashMap<String, RestrictionDefinition>();
                Set supportedRestrictions = this.restrictionProvider.getSupportedRestrictions(resourcePath);
                for (RestrictionDefinition restrictionDefinition : supportedRestrictions) {
                    supportedRestrictionsMap.put(restrictionDefinition.getName(), restrictionDefinition);
                }
            }
            if (paramName.endsWith("@Delete")) {
                restrictionName = paramName.substring(12, paramName.length() - 7);
                removeRestrictionNames.add(restrictionName);
                continue;
            }
            restrictionName = paramName.substring(12);
            String[] parameterValues = request.getParameterValues(paramName);
            if (parameterValues == null) continue;
            RestrictionDefinition rd = (RestrictionDefinition)supportedRestrictionsMap.get(restrictionName);
            if (rd == null) {
                throw new IllegalArgumentException("Invalid or not supported restriction name was supplied");
            }
            boolean multival = rd.getRequiredType().isArray();
            int restrictionType = rd.getRequiredType().tag();
            if (multival) {
                v = new Value[parameterValues.length];
                for (int j = 0; j < parameterValues.length; ++j) {
                    String string = parameterValues[j];
                    v[j] = factory.createValue(string, restrictionType);
                }
                mvRestrictions.put(restrictionName, (Value[])v);
                continue;
            }
            if (parameterValues.length <= 0) continue;
            v = factory.createValue(parameterValues[0], restrictionType);
            restrictions.put(restrictionName, v);
        }
        String order = request.getParameter("order");
        this.modifyAce(session, resourcePath, principalId, privileges, order, restrictions, mvRestrictions, removeRestrictionNames, false, changes);
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order, boolean autoSave) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, privileges, order, null, null, null, autoSave);
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, privileges, order, true);
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removeRestrictionNames) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, privileges, order, restrictions, mvRestrictions, removeRestrictionNames, true);
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removeRestrictionNames, boolean autoSave) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, privileges, order, restrictions, mvRestrictions, removeRestrictionNames, autoSave, null);
    }

    protected void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removeRestrictionNames, boolean autoSave, List<Modification> changes) throws RepositoryException {
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        if (principalId == null) {
            throw new RepositoryException("principalId was not submitted.");
        }
        PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)jcrSession);
        Principal principal = principalManager.getPrincipal(principalId);
        if (principal == null) {
            throw new RepositoryException("Invalid principalId was submitted.");
        }
        if (resourcePath == null) {
            throw new ResourceNotFoundException("Resource path was not supplied.");
        }
        Item item = jcrSession.getItem(resourcePath);
        if (item == null) {
            throw new ResourceNotFoundException("Resource is not a JCR Node");
        }
        resourcePath = item.getPath();
        HashSet<String> grantedPrivilegeNames = new HashSet<String>();
        HashSet<String> deniedPrivilegeNames = new HashSet<String>();
        HashSet<String> removedPrivilegeNames = new HashSet<String>();
        if (privileges != null) {
            Set<Map.Entry<String, String>> entrySet = privileges.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String parameterValue;
                String privilegeName = entry.getKey();
                if (privilegeName.startsWith("privilege@")) {
                    privilegeName = privilegeName.substring(10);
                }
                if ((parameterValue = entry.getValue()) == null || parameterValue.length() <= 0) continue;
                if ("granted".equals(parameterValue)) {
                    grantedPrivilegeNames.add(privilegeName);
                    continue;
                }
                if ("denied".equals(parameterValue)) {
                    deniedPrivilegeNames.add(privilegeName);
                    continue;
                }
                if (!"none".equals(parameterValue)) continue;
                removedPrivilegeNames.add(privilegeName);
            }
        }
        try {
            AccessControlUtil.replaceAccessControlEntry((Session)jcrSession, (String)resourcePath, (Principal)principal, (String[])grantedPrivilegeNames.toArray(new String[grantedPrivilegeNames.size()]), (String[])deniedPrivilegeNames.toArray(new String[deniedPrivilegeNames.size()]), (String[])removedPrivilegeNames.toArray(new String[removedPrivilegeNames.size()]), (String)order, restrictions, mvRestrictions, removeRestrictionNames);
            if (changes != null) {
                changes.add(Modification.onModified((String)principal.getName()));
            }
            if (autoSave && jcrSession.hasPendingChanges()) {
                jcrSession.save();
            }
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to create ace.", (Throwable)re);
        }
    }
}

