/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.json.JsonObject;
import javax.servlet.Servlet;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetAcl;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractGetAclServlet;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class, GetAcl.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET", "sling.servlet.selectors=acl", "sling.servlet.selectors=tidy.acl", "sling.servlet.extensions=json", "sling.servlet.prefix:Integer=-1"})
public class GetAclServlet
extends AbstractGetAclServlet
implements GetAcl {
    private static final long serialVersionUID = 3391376559396223185L;

    @Override
    public JsonObject getAcl(Session jcrSession, String resourcePath) throws RepositoryException {
        return this.internalGetAcl(jcrSession, resourcePath);
    }

    @Override
    protected AccessControlEntry[] getAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        AccessControlPolicy[] policies = accessControlManager.getPolicies(absPath);
        ArrayList<AccessControlEntry> allEntries = new ArrayList<AccessControlEntry>();
        for (AccessControlPolicy accessControlPolicy : policies) {
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
            allEntries.addAll(Arrays.asList(accessControlEntries));
        }
        return allEntries.toArray(new AccessControlEntry[allEntries.size()]);
    }
}

