/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.Privilege;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.servlet.ServletException;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.PrivilegesHelper;

public abstract class AbstractGetAclServlet
extends SlingAllMethodsServlet {
    protected static final String KEY_ORDER = "order";
    protected static final String KEY_DENIED = "denied";
    protected static final String KEY_GRANTED = "granted";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            String resourcePath = request.getResource().getPath();
            JsonObject acl = this.internalGetAcl(session, resourcePath);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            boolean isTidy = false;
            String[] selectors = request.getRequestPathInfo().getSelectors();
            if (selectors.length > 0) {
                for (String level : selectors) {
                    if (!"tidy".equals(level)) continue;
                    isTidy = true;
                    break;
                }
            }
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("javax.json.stream.JsonGenerator.prettyPrinting", isTidy);
            try (JsonGenerator generator = Json.createGeneratorFactory(options).createGenerator((Writer)response.getWriter());){
                generator.write((JsonValue)acl).flush();
            }
        }
        catch (AccessDeniedException ade) {
            response.sendError(404);
        }
        catch (ResourceNotFoundException rnfe) {
            response.sendError(404, rnfe.getMessage());
        }
        catch (Exception throwable) {
            throw new ServletException(String.format("Exception while handling GET %s with %s", request.getResource().getPath(), ((Object)((Object)this)).getClass().getName()), (Throwable)throwable);
        }
    }

    protected JsonObject internalGetAcl(Session jcrSession, String resourcePath) throws RepositoryException {
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        Item item = jcrSession.getItem(resourcePath);
        if (item == null) {
            throw new ResourceNotFoundException("Resource is not a JCR Node");
        }
        resourcePath = item.getPath();
        Map<Privilege, Set<Privilege>> privilegeToAncestorMap = PrivilegesHelper.buildPrivilegeToAncestorMap(jcrSession, resourcePath);
        AccessControlEntry[] declaredAccessControlEntries = this.getAccessControlEntries(jcrSession, resourcePath);
        LinkedHashMap aclMap = new LinkedHashMap();
        LinkedHashMap restrictionMap = new LinkedHashMap();
        int sequence = 0;
        for (AccessControlEntry ace : declaredAccessControlEntries) {
            Principal principal = ace.getPrincipal();
            LinkedHashMap<String, Integer> map = (LinkedHashMap<String, Integer>)aclMap.get(principal.getName());
            if (map != null) continue;
            map = new LinkedHashMap<String, Integer>();
            aclMap.put(principal.getName(), map);
            map.put(KEY_ORDER, sequence++);
        }
        for (int i = declaredAccessControlEntries.length - 1; i >= 0; --i) {
            Privilege[] privileges;
            boolean allow;
            LinkedHashSet<Privilege> deniedSet;
            Map map;
            LinkedHashSet<Privilege> grantedSet;
            JackrabbitAccessControlEntry jace;
            String[] restrictionNames;
            AccessControlEntry ace = declaredAccessControlEntries[i];
            Principal principal = ace.getPrincipal();
            if (ace instanceof JackrabbitAccessControlEntry && (restrictionNames = (jace = (JackrabbitAccessControlEntry)ace).getRestrictionNames()) != null) {
                HashMap<String, Object> restrictions = (HashMap<String, Object>)restrictionMap.get(principal.getName());
                if (restrictions == null) {
                    restrictions = new HashMap<String, Object>();
                    restrictionMap.put(principal.getName(), restrictions);
                }
                for (String rname : restrictionNames) {
                    try {
                        Value value = jace.getRestriction(rname);
                        restrictions.put(rname, value);
                    }
                    catch (ValueFormatException vfe) {
                        Value[] values = jace.getRestrictions(rname);
                        restrictions.put(rname, values);
                    }
                }
            }
            if ((grantedSet = (LinkedHashSet<Privilege>)(map = (Map)aclMap.get(principal.getName())).get(KEY_GRANTED)) == null) {
                grantedSet = new LinkedHashSet<Privilege>();
                map.put(KEY_GRANTED, grantedSet);
            }
            if ((deniedSet = (LinkedHashSet<Privilege>)map.get(KEY_DENIED)) == null) {
                deniedSet = new LinkedHashSet<Privilege>();
                map.put(KEY_DENIED, deniedSet);
            }
            if (allow = AccessControlUtil.isAllow((AccessControlEntry)ace)) {
                for (Privilege privilege : privileges = ace.getPrivileges()) {
                    PrivilegesHelper.mergePrivilegeSets(privilege, privilegeToAncestorMap, grantedSet, deniedSet);
                }
                continue;
            }
            for (Privilege privilege : privileges = ace.getPrivileges()) {
                PrivilegesHelper.mergePrivilegeSets(privilege, privilegeToAncestorMap, deniedSet, grantedSet);
            }
        }
        ArrayList<JsonObject> aclList = new ArrayList<JsonObject>();
        Set entrySet = aclMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Set deniedSet;
            String principalName = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            JsonObjectBuilder aceObject = Json.createObjectBuilder();
            aceObject.add("principal", principalName);
            Set grantedSet = (Set)value.get(KEY_GRANTED);
            if (grantedSet != null && !grantedSet.isEmpty()) {
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                for (Object v : grantedSet) {
                    arrayBuilder.add(v.getName());
                }
                aceObject.add(KEY_GRANTED, arrayBuilder);
            }
            if ((deniedSet = (Set)value.get(KEY_DENIED)) != null && !deniedSet.isEmpty()) {
                Object v;
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                v = deniedSet.iterator();
                while (v.hasNext()) {
                    Privilege v2 = (Privilege)v.next();
                    arrayBuilder.add(v2.getName());
                }
                aceObject.add(KEY_DENIED, arrayBuilder);
            }
            aceObject.add(KEY_ORDER, ((Integer)value.get(KEY_ORDER)).intValue());
            Map restrictions = (Map)restrictionMap.get(principalName);
            if (restrictions != null && !restrictions.isEmpty()) {
                Set entrySet2 = restrictions.entrySet();
                JsonObjectBuilder jsonRestrictions = Json.createObjectBuilder();
                for (Map.Entry entry2 : entrySet2) {
                    Object rvalue = entry2.getValue();
                    if (rvalue == null) continue;
                    if (rvalue.getClass().isArray()) {
                        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                        int length = Array.getLength(rvalue);
                        for (int i = 0; i < length; ++i) {
                            Object object = Array.get(rvalue, i);
                            this.addTo(arrayBuilder, object);
                        }
                        jsonRestrictions.add((String)entry2.getKey(), arrayBuilder);
                        continue;
                    }
                    this.addTo(jsonRestrictions, (String)entry2.getKey(), rvalue);
                }
                aceObject.add("restrictions", jsonRestrictions);
            }
            aclList.add(aceObject.build());
        }
        JsonObjectBuilder jsonAclMap = Json.createObjectBuilder();
        for (Map.Entry entry : aclMap.entrySet()) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry inner : ((Map)entry.getValue()).entrySet()) {
                this.addTo(builder, (String)inner.getKey(), inner.getValue());
            }
            jsonAclMap.add((String)entry.getKey(), builder);
        }
        for (JsonObject jsonObj : aclList) {
            jsonAclMap.add(jsonObj.getString("principal"), (JsonValue)jsonObj);
        }
        return jsonAclMap.build();
    }

    private JsonObjectBuilder addTo(JsonObjectBuilder builder, String key, Object value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            builder.add(key, ((Number)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            builder.add(key, ((Number)value).doubleValue());
        } else if (value instanceof Privilege) {
            JsonObjectBuilder privilegeBuilder = Json.createObjectBuilder();
            privilegeBuilder.add("name", ((Privilege)value).getName());
            builder.add(key, privilegeBuilder);
        } else if (value instanceof String) {
            builder.add(key, (String)value);
        } else {
            builder.add(key, value.toString());
        }
        return builder;
    }

    private JsonArrayBuilder addTo(JsonArrayBuilder builder, Object value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            builder.add(((Number)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            builder.add(((Number)value).doubleValue());
        } else if (value instanceof String) {
            builder.add((String)value);
        } else {
            builder.add(value.toString());
        }
        return builder;
    }

    protected abstract AccessControlEntry[] getAccessControlEntries(Session var1, String var2) throws RepositoryException;
}

