/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.ModifyAce;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessPostServlet;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.Modification;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class, ModifyAce.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=POST", "sling.servlet.selectors=modifyAce"})
public class ModifyAceServlet
extends AbstractAccessPostServlet
implements ModifyAce {
    private static final long serialVersionUID = -9182485466670280437L;

    @Override
    protected void handleOperation(SlingHttpServletRequest request, AbstractPostResponse response, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String resourcePath = request.getResource().getPath();
        String principalId = request.getParameter("principalId");
        HashMap<String, String> privileges = new HashMap<String, String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName;
            Object nextElement = parameterNames.nextElement();
            if (!(nextElement instanceof String) || !(paramName = (String)nextElement).startsWith("privilege@")) continue;
            String privilegeName = paramName.substring(10);
            String parameterValue = request.getParameter(paramName);
            privileges.put(privilegeName, parameterValue);
        }
        String order = request.getParameter("order");
        this.modifyAce(session, resourcePath, principalId, privileges, order);
    }

    @Override
    public void modifyAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order) throws RepositoryException {
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        if (principalId == null) {
            throw new RepositoryException("principalId was not submitted.");
        }
        PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)jcrSession);
        Principal principal = principalManager.getPrincipal(principalId);
        if (resourcePath == null) {
            throw new ResourceNotFoundException("Resource path was not supplied.");
        }
        Item item = jcrSession.getItem(resourcePath);
        if (item == null) {
            throw new ResourceNotFoundException("Resource is not a JCR Node");
        }
        resourcePath = item.getPath();
        HashSet<String> grantedPrivilegeNames = new HashSet<String>();
        HashSet<String> deniedPrivilegeNames = new HashSet<String>();
        HashSet<String> removedPrivilegeNames = new HashSet<String>();
        Set<Map.Entry<String, String>> entrySet = privileges.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String parameterValue;
            String privilegeName = entry.getKey();
            if (privilegeName.startsWith("privilege@")) {
                privilegeName = privilegeName.substring(10);
            }
            if ((parameterValue = entry.getValue()) == null || parameterValue.length() <= 0) continue;
            if ("granted".equals(parameterValue)) {
                grantedPrivilegeNames.add(privilegeName);
                continue;
            }
            if ("denied".equals(parameterValue)) {
                deniedPrivilegeNames.add(privilegeName);
                continue;
            }
            if (!"none".equals(parameterValue)) continue;
            removedPrivilegeNames.add(privilegeName);
        }
        try {
            AccessControlUtil.replaceAccessControlEntry((Session)jcrSession, (String)resourcePath, (Principal)principal, (String[])grantedPrivilegeNames.toArray(new String[grantedPrivilegeNames.size()]), (String[])deniedPrivilegeNames.toArray(new String[deniedPrivilegeNames.size()]), (String[])removedPrivilegeNames.toArray(new String[removedPrivilegeNames.size()]), (String)order);
            if (jcrSession.hasPendingChanges()) {
                jcrSession.save();
            }
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to create ace.", (Throwable)re);
        }
    }
}

