/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.DeleteAces;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessPostServlet;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.Modification;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class, DeleteAces.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=POST", "sling.servlet.selectors=deleteAce"})
public class DeleteAcesServlet
extends AbstractAccessPostServlet
implements DeleteAces {
    private static final long serialVersionUID = 3784866802938282971L;

    @Override
    protected void handleOperation(SlingHttpServletRequest request, AbstractPostResponse htmlResponse, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String resourcePath = request.getResource().getPath();
        String[] applyTo = request.getParameterValues(":applyTo");
        this.deleteAces(session, resourcePath, applyTo);
    }

    @Override
    public void deleteAces(Session jcrSession, String resourcePath, String[] principalNamesToDelete) throws RepositoryException {
        if (principalNamesToDelete == null) {
            throw new RepositoryException("principalIds were not sumitted.");
        }
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        if (resourcePath == null) {
            throw new ResourceNotFoundException("Resource path was not supplied.");
        }
        Item item = jcrSession.getItem(resourcePath);
        if (item == null) {
            throw new ResourceNotFoundException("Resource is not a JCR Node");
        }
        resourcePath = item.getPath();
        HashSet<String> pidSet = new HashSet<String>();
        pidSet.addAll(Arrays.asList(principalNamesToDelete));
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)jcrSession);
            AccessControlList updatedAcl = this.getAccessControlList(accessControlManager, resourcePath, false);
            AccessControlEntry[] accessControlEntries = updatedAcl.getAccessControlEntries();
            ArrayList<AccessControlEntry> oldAces = new ArrayList<AccessControlEntry>();
            for (AccessControlEntry ace : accessControlEntries) {
                if (!pidSet.contains(ace.getPrincipal().getName())) continue;
                oldAces.add(ace);
            }
            if (!oldAces.isEmpty()) {
                for (AccessControlEntry ace : oldAces) {
                    updatedAcl.removeAccessControlEntry(ace);
                }
            }
            accessControlManager.setPolicy(resourcePath, (AccessControlPolicy)updatedAcl);
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to delete access control.", (Throwable)re);
        }
    }
}

