/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGetAclServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            String resourcePath = request.getResource().getPath();
            JsonObject acl = this.internalGetAcl(session, resourcePath);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            boolean isTidy = false;
            String[] selectors = request.getRequestPathInfo().getSelectors();
            if (selectors != null && selectors.length > 0) {
                for (String level : selectors) {
                    if (!"tidy".equals(level)) continue;
                    isTidy = true;
                    break;
                }
            }
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("javax.json.stream.JsonGenerator.prettyPrinting", isTidy);
            Json.createGeneratorFactory(options).createGenerator((Writer)response.getWriter()).write((JsonValue)acl).flush();
        }
        catch (AccessDeniedException ade) {
            response.sendError(404);
        }
        catch (ResourceNotFoundException rnfe) {
            response.sendError(404, rnfe.getMessage());
        }
        catch (Throwable throwable) {
            this.log.debug("Exception while handling GET " + request.getResource().getPath() + " with " + ((Object)((Object)this)).getClass().getName(), throwable);
            throw new ServletException(throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected JsonObject internalGetAcl(Session jcrSession, String resourcePath) throws RepositoryException {
        void var10_14;
        Privilege[] supportedPrivileges;
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        Item item = jcrSession.getItem(resourcePath);
        if (item == null) {
            throw new ResourceNotFoundException("Resource is not a JCR Node");
        }
        resourcePath = item.getPath();
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)jcrSession);
        HashMap<Privilege, Set<Privilege>> privilegeToAncestorMap = new HashMap<Privilege, Set<Privilege>>();
        for (Privilege privilege : supportedPrivileges = accessControlManager.getSupportedPrivileges(item.getPath())) {
            Privilege[] ap;
            if (!privilege.isAggregate()) continue;
            for (Privilege privilege2 : ap = privilege.getAggregatePrivileges()) {
                HashSet<Privilege> set = (HashSet<Privilege>)privilegeToAncestorMap.get(privilege2);
                if (set == null) {
                    set = new HashSet<Privilege>();
                    privilegeToAncestorMap.put(privilege2, set);
                }
                set.add(privilege);
            }
        }
        AccessControlEntry[] declaredAccessControlEntries = this.getAccessControlEntries(jcrSession, resourcePath);
        LinkedHashMap aclMap = new LinkedHashMap();
        int sequence = 0;
        for (AccessControlEntry ace : declaredAccessControlEntries) {
            Principal principal = ace.getPrincipal();
            LinkedHashMap<String, Integer> map = (LinkedHashMap<String, Integer>)aclMap.get(principal.getName());
            if (map != null) continue;
            map = new LinkedHashMap<String, Integer>();
            aclMap.put(principal.getName(), map);
            map.put("order", sequence++);
        }
        int n = declaredAccessControlEntries.length - 1;
        while (var10_14 >= 0) {
            Privilege[] privileges;
            boolean allow;
            LinkedHashSet<Privilege> deniedSet;
            AccessControlEntry ace = declaredAccessControlEntries[var10_14];
            Principal principal = ace.getPrincipal();
            Map map = (Map)aclMap.get(principal.getName());
            LinkedHashSet<Privilege> grantedSet = (LinkedHashSet<Privilege>)map.get("granted");
            if (grantedSet == null) {
                grantedSet = new LinkedHashSet<Privilege>();
                map.put("granted", grantedSet);
            }
            if ((deniedSet = (LinkedHashSet<Privilege>)map.get("denied")) == null) {
                deniedSet = new LinkedHashSet<Privilege>();
                map.put("denied", deniedSet);
            }
            if (allow = AccessControlUtil.isAllow((AccessControlEntry)ace)) {
                for (Privilege privilege : privileges = ace.getPrivileges()) {
                    this.mergePrivilegeSets(privilege, privilegeToAncestorMap, grantedSet, deniedSet);
                }
            } else {
                for (Privilege privilege : privileges = ace.getPrivileges()) {
                    this.mergePrivilegeSets(privilege, privilegeToAncestorMap, deniedSet, grantedSet);
                }
            }
            --var10_14;
        }
        ArrayList<JsonObject> arrayList = new ArrayList<JsonObject>();
        Set entrySet = aclMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Set deniedSet;
            String principalName = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            JsonObjectBuilder aceObject = Json.createObjectBuilder();
            aceObject.add("principal", principalName);
            Set grantedSet = (Set)value.get("granted");
            if (grantedSet != null && !grantedSet.isEmpty()) {
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                for (Privilege v : grantedSet) {
                    arrayBuilder.add(v.getName());
                }
                aceObject.add("granted", arrayBuilder);
            }
            if ((deniedSet = (Set)value.get("denied")) != null && !deniedSet.isEmpty()) {
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                for (Privilege v : deniedSet) {
                    arrayBuilder.add(v.getName());
                }
                aceObject.add("denied", arrayBuilder);
            }
            aceObject.add("order", ((Integer)value.get("order")).intValue());
            arrayList.add(aceObject.build());
        }
        JsonObjectBuilder jsonAclMap = Json.createObjectBuilder();
        for (Map.Entry entry : aclMap.entrySet()) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry inner : ((Map)entry.getValue()).entrySet()) {
                this.addTo(builder, (String)inner.getKey(), inner.getValue());
            }
            jsonAclMap.add((String)entry.getKey(), builder);
        }
        for (JsonObject jsonObj : arrayList) {
            jsonAclMap.add(jsonObj.getString("principal"), (JsonValue)jsonObj);
        }
        return jsonAclMap.build();
    }

    private JsonObjectBuilder addTo(JsonObjectBuilder builder, String key, Object value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            builder.add(key, ((Number)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            builder.add(key, ((Number)value).doubleValue());
        } else if (value instanceof Privilege) {
            JsonObjectBuilder privilegeBuilder = Json.createObjectBuilder();
            privilegeBuilder.add("name", ((Privilege)value).getName());
            builder.add(key, privilegeBuilder);
        } else if (value instanceof String) {
            builder.add(key, (String)value);
        } else {
            builder.add(key, value.toString());
        }
        return builder;
    }

    private void mergePrivilegeSets(Privilege privilege, Map<Privilege, Set<Privilege>> privilegeToAncestorMap, Set<Privilege> firstSet, Set<Privilege> secondSet) {
        Set<Privilege> filterSet;
        if (privilege.isAggregate()) {
            Privilege[] aggregatePrivileges = privilege.getAggregatePrivileges();
            List<Privilege> asList = Arrays.asList(aggregatePrivileges);
            firstSet.removeAll(asList);
            secondSet.removeAll(asList);
        }
        secondSet.remove(privilege);
        boolean isAlreadyGranted = false;
        Set<Privilege> ancestorSet = privilegeToAncestorMap.get(privilege);
        if (ancestorSet != null) {
            for (Privilege privilege2 : ancestorSet) {
                if (!firstSet.contains(privilege2)) continue;
                isAlreadyGranted = true;
                break;
            }
        }
        if (!isAlreadyGranted) {
            firstSet.add(privilege);
        }
        if ((filterSet = privilegeToAncestorMap.get(privilege)) != null) {
            for (Privilege privilege2 : filterSet) {
                if (!secondSet.contains(privilege2)) continue;
                secondSet.remove(privilege2);
                if (!privilege2.isAggregate()) continue;
                this.filterAndMergePrivilegesFromAggregate(privilege2, firstSet, secondSet, filterSet, privilege);
            }
        }
    }

    private void filterAndMergePrivilegesFromAggregate(Privilege privilege, Set<Privilege> firstSet, Set<Privilege> secondSet, Set<Privilege> filterSet, Privilege ignorePrivilege) {
        Privilege[] declaredAggregatePrivileges;
        for (Privilege privilege3 : declaredAggregatePrivileges = privilege.getDeclaredAggregatePrivileges()) {
            Privilege[] declaredAggregatePrivileges2;
            if (ignorePrivilege.equals(privilege3)) continue;
            if (!firstSet.contains(privilege3) && !filterSet.contains(privilege3)) {
                secondSet.add(privilege3);
            }
            if (!privilege3.isAggregate()) continue;
            for (Privilege privilege2 : declaredAggregatePrivileges2 = privilege3.getDeclaredAggregatePrivileges()) {
                if (ignorePrivilege.equals(privilege2) || !privilege2.isAggregate()) continue;
                this.filterAndMergePrivilegesFromAggregate(privilege2, firstSet, secondSet, filterSet, ignorePrivilege);
            }
        }
    }

    protected abstract AccessControlEntry[] getAccessControlEntries(Session var1, String var2) throws RepositoryException;
}

