/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.Item;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionManager;
import org.apache.commons.io.IOUtils;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.apache.sling.jcr.contentloader.internal.BaseImportLoader;
import org.apache.sling.jcr.contentloader.internal.BundleHelper;
import org.apache.sling.jcr.contentloader.internal.ContentReaderWhiteboard;
import org.apache.sling.jcr.contentloader.internal.DefaultContentCreator;
import org.apache.sling.jcr.contentloader.internal.PathEntry;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleContentLoader
extends BaseImportLoader {
    public static final String PARENT_DESCRIPTOR = "ROOT";
    private final Logger log = LoggerFactory.getLogger(BundleContentLoader.class);
    private BundleHelper bundleHelper;
    private List<Bundle> delayedBundles;

    public BundleContentLoader(BundleHelper bundleHelper, ContentReaderWhiteboard contentReaderWhiteboard) {
        super(contentReaderWhiteboard);
        this.bundleHelper = bundleHelper;
        this.delayedBundles = new LinkedList<Bundle>();
    }

    public void dispose() {
        if (this.delayedBundles != null) {
            this.delayedBundles.clear();
            this.delayedBundles = null;
        }
        this.bundleHelper = null;
    }

    public void registerBundle(Session metadataSession, Bundle bundle, boolean isUpdate) throws RepositoryException {
        if (isUpdate) {
            this.unregisterBundle(metadataSession, bundle);
        }
        this.log.debug("Registering bundle {} for content loading.", (Object)bundle.getSymbolicName());
        if (this.registerBundleInternal(metadataSession, bundle, false, isUpdate)) {
            int currentSize = -1;
            for (int i = this.delayedBundles.size(); i > 0 && currentSize != this.delayedBundles.size() && !this.delayedBundles.isEmpty(); --i) {
                Iterator<Bundle> di = this.delayedBundles.iterator();
                while (di.hasNext()) {
                    Bundle delayed = di.next();
                    if (!this.registerBundleInternal(metadataSession, delayed, true, false)) continue;
                    di.remove();
                }
                currentSize = this.delayedBundles.size();
            }
        } else if (!isUpdate) {
            this.delayedBundles.add(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerBundleInternal(Session metadataSession, Bundle bundle, boolean isRetry, boolean isUpdate) {
        boolean bl;
        Iterator<PathEntry> pathIter = PathEntry.getContentPaths(bundle);
        if (pathIter == null) {
            this.log.debug("Bundle {} has no initial content", (Object)bundle.getSymbolicName());
            return true;
        }
        this.bundleHelper.createRepositoryPath(metadataSession, "/var/sling/bundle-content");
        Map<String, Object> bundleContentInfo = this.bundleHelper.getBundleContentInfo(metadataSession, bundle, true);
        if (bundleContentInfo == null) {
            return false;
        }
        boolean success = false;
        List<String> createdNodes = null;
        try {
            boolean contentAlreadyLoaded = (Boolean)bundleContentInfo.get("content-loaded");
            boolean isBundleUpdated = false;
            Calendar lastLoadedAt = (Calendar)bundleContentInfo.get("content-load-time");
            if (lastLoadedAt != null && lastLoadedAt.getTimeInMillis() < bundle.getLastModified()) {
                isBundleUpdated = true;
            }
            if (!isUpdate && !isBundleUpdated && contentAlreadyLoaded) {
                this.log.info("Content of bundle already loaded {}.", (Object)bundle.getSymbolicName());
            } else {
                createdNodes = this.installContent(metadataSession, bundle, pathIter, contentAlreadyLoaded && !isBundleUpdated);
                if (isRetry) {
                    this.log.info("Retrying to load initial content for bundle {} succeeded.", (Object)bundle.getSymbolicName());
                }
            }
            success = true;
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.bundleHelper.unlockBundleContentInfo(metadataSession, bundle, success, createdNodes);
                throw throwable;
            }
            catch (RepositoryException re) {
                if (!isRetry) {
                    this.log.error("Cannot load initial content for bundle " + bundle.getSymbolicName() + " : " + re.getMessage(), (Throwable)re);
                }
                return false;
            }
        }
        this.bundleHelper.unlockBundleContentInfo(metadataSession, bundle, success, createdNodes);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBundle(Session session, Bundle bundle) {
        if (this.delayedBundles.contains(bundle)) {
            this.delayedBundles.remove(bundle);
        } else {
            try {
                this.bundleHelper.createRepositoryPath(session, "/var/sling/bundle-content");
                Map<String, Object> bundleContentInfo = this.bundleHelper.getBundleContentInfo(session, bundle, false);
                if (bundleContentInfo == null) {
                    return;
                }
                try {
                    this.uninstallContent(session, bundle, (String[])bundleContentInfo.get("uninstall-paths"));
                    this.bundleHelper.contentIsUninstalled(session, bundle);
                }
                finally {
                    this.bundleHelper.unlockBundleContentInfo(session, bundle, false, null);
                }
            }
            catch (RepositoryException re) {
                this.log.error("Cannot remove initial content for bundle " + bundle.getSymbolicName() + " : " + re.getMessage(), (Throwable)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> installContent(Session defaultSession, Bundle bundle, Iterator<PathEntry> pathIter, boolean contentAlreadyLoaded) throws RepositoryException {
        ArrayList<String> createdNodes = new ArrayList<String>();
        HashMap<String, Session> createdSessions = new HashMap<String, Session>();
        this.log.debug("Installing initial content from bundle {}", (Object)bundle.getSymbolicName());
        DefaultContentCreator contentCreator = new DefaultContentCreator(this.bundleHelper);
        try {
            while (pathIter.hasNext()) {
                Node targetNode;
                Session targetSession;
                PathEntry pathEntry = pathIter.next();
                if (contentAlreadyLoaded && !pathEntry.isOverwrite()) continue;
                String workspace = pathEntry.getWorkspace();
                if (workspace != null) {
                    if (createdSessions.containsKey(workspace)) {
                        targetSession = (Session)createdSessions.get(workspace);
                    } else {
                        targetSession = this.createSession(workspace);
                        createdSessions.put(workspace, targetSession);
                    }
                } else {
                    targetSession = defaultSession;
                }
                if ((targetNode = this.getTargetNode(targetSession, pathEntry.getTarget())) == null) continue;
                this.installFromPath(bundle, pathEntry.getPath(), pathEntry, targetNode, pathEntry.isUninstall() ? createdNodes : null, contentCreator);
            }
            Collections.sort(createdNodes);
            if (createdNodes.size() > 1) {
                Iterator<Object> i = createdNodes.iterator();
                String previous = (String)i.next() + '/';
                while (i.hasNext()) {
                    String current = (String)i.next();
                    if (current.startsWith(previous)) {
                        i.remove();
                        continue;
                    }
                    previous = current + '/';
                }
            }
            defaultSession.refresh(true);
            defaultSession.save();
            for (Session session : createdSessions.values()) {
                session.refresh(true);
                session.save();
            }
            for (Node versionable : contentCreator.getVersionables()) {
                VersionManager versionManager = versionable.getSession().getWorkspace().getVersionManager();
                versionManager.checkin(versionable.getPath());
            }
        }
        catch (Throwable throwable) {
            try {
                if (defaultSession.hasPendingChanges()) {
                    defaultSession.refresh(false);
                }
                for (Session session : createdSessions.values()) {
                    if (!session.hasPendingChanges()) continue;
                    session.refresh(false);
                }
            }
            catch (RepositoryException re) {
                this.log.warn("Failure to rollback partial initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re);
            }
            contentCreator.clear();
            Iterator iterator = createdSessions.values().iterator();
            while (true) {
                Session session;
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                session = (Session)iterator.next();
                session.logout();
            }
        }
        try {
            if (defaultSession.hasPendingChanges()) {
                defaultSession.refresh(false);
            }
            for (Session session : createdSessions.values()) {
                if (!session.hasPendingChanges()) continue;
                session.refresh(false);
            }
        }
        catch (RepositoryException re) {
            this.log.warn("Failure to rollback partial initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re);
        }
        contentCreator.clear();
        Iterator iterator = createdSessions.values().iterator();
        while (true) {
            Session session;
            if (!iterator.hasNext()) {
                this.log.debug("Done installing initial content from bundle {}", (Object)bundle.getSymbolicName());
                return createdNodes;
            }
            session = (Session)iterator.next();
            session.logout();
        }
    }

    private void installFromPath(Bundle bundle, String path, PathEntry configuration, Node parent, List<String> createdNodes, DefaultContentCreator contentCreator) throws RepositoryException {
        contentCreator.init(configuration, this.getContentReaders(), createdNodes, null);
        HashMap<String, Node> processedEntries = new HashMap<String, Node>();
        Enumeration entries = bundle.getEntryPaths(path);
        if (entries == null) {
            URL u = bundle.getEntry(path);
            if (u == null) {
                this.log.info("install: No initial content entries at {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                return;
            }
            for (String ext : contentCreator.getContentReaders().keySet()) {
                if (!path.endsWith(ext)) continue;
            }
            this.handleFile(path, bundle, processedEntries, configuration, parent, createdNodes, contentCreator);
            return;
        }
        URL parentNodeDescriptor = this.importParentNode(bundle, path, parent, contentCreator);
        if (parentNodeDescriptor != null) {
            processedEntries.put(parentNodeDescriptor.toString(), parent);
        }
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            this.log.debug("Processing initial content entry {} in bundle {}", (Object)entry, (Object)bundle.getSymbolicName());
            if (entry.endsWith("/")) {
                String base = entry.substring(0, entry.length() - 1);
                URL nodeDescriptor = null;
                for (String ext : contentCreator.getContentReaders().keySet()) {
                    nodeDescriptor = bundle.getEntry(base + ext);
                    if (nodeDescriptor == null) continue;
                    break;
                }
                String name = this.getName(base);
                Node node = null;
                if (nodeDescriptor != null) {
                    node = (Node)processedEntries.get(nodeDescriptor.toString());
                    if (node == null) {
                        node = this.createNode(parent, name, nodeDescriptor, contentCreator, configuration);
                        processedEntries.put(nodeDescriptor.toString(), node);
                    }
                } else {
                    node = this.createFolder(parent, name, configuration.isOverwrite());
                }
                if (node == null) continue;
                this.installFromPath(bundle, entry, configuration, node, createdNodes, contentCreator);
                continue;
            }
            this.handleFile(entry, bundle, processedEntries, configuration, parent, createdNodes, contentCreator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFile(String entry, Bundle bundle, Map<String, Node> processedEntries, PathEntry configuration, Node parent, List<String> createdNodes, DefaultContentCreator contentCreator) throws RepositoryException {
        block14: {
            URL file = bundle.getEntry(entry);
            String name = this.getName(entry);
            try {
                if (processedEntries.containsKey(file.toString())) {
                    return;
                }
                URL nodeDescriptor = null;
                for (String ext : contentCreator.getContentReaders().keySet()) {
                    nodeDescriptor = bundle.getEntry(entry + ext);
                    if (nodeDescriptor == null) continue;
                    break;
                }
                boolean foundReader = this.getContentReader(entry, configuration) != null;
                Node node = null;
                if (foundReader) {
                    node = this.createNode(parent, name, file, contentCreator, configuration);
                    if (node != null) {
                        this.log.debug("Created node as {} {}", (Object)node.getPath(), (Object)name);
                        processedEntries.put(file.toString(), node);
                    } else {
                        this.log.warn("No node created for file {} {}", (Object)file, (Object)name);
                    }
                } else {
                    this.log.debug("Can't find content reader for entry {} at {}", (Object)entry, (Object)name);
                }
                if (node == null) {
                    try {
                        this.createFile(configuration, parent, file, createdNodes, contentCreator);
                        node = parent.getNode(name);
                    }
                    catch (IOException ioe) {
                        this.log.warn("Cannot create file node for {}", (Object)file, (Object)ioe);
                    }
                }
                if (nodeDescriptor == null || processedEntries.containsKey(nodeDescriptor.toString())) break block14;
                try {
                    contentCreator.setIgnoreOverwriteFlag(true);
                    node = this.createNode(parent, name, nodeDescriptor, contentCreator, configuration);
                    processedEntries.put(nodeDescriptor.toString(), node);
                }
                finally {
                    contentCreator.setIgnoreOverwriteFlag(false);
                }
            }
            catch (RepositoryException e) {
                this.log.error("Failed to process file {} from {}", (Object)file, (Object)name);
                throw e;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node createNode(Node parent, String name, URL resourceUrl, DefaultContentCreator contentCreator, PathEntry configuration) throws RepositoryException {
        Node node;
        ContentReader nodeReader;
        InputStream contentStream;
        block8: {
            String resourcePath;
            block7: {
                resourcePath = resourceUrl.getPath().toLowerCase();
                contentStream = null;
                if (!resourcePath.endsWith(".jcr.xml")) break block7;
                contentStream = resourceUrl.openStream();
                Node node2 = this.importJcrXml(parent, name, contentStream, false);
                IOUtils.closeQuietly((InputStream)contentStream);
                return node2;
            }
            nodeReader = this.getContentReader(resourcePath, configuration);
            if (nodeReader != null) break block8;
            Node node3 = null;
            IOUtils.closeQuietly((InputStream)contentStream);
            return node3;
        }
        try {
            String contentReaderExtension = this.getContentReaderExtension(name);
            contentCreator.prepareParsing(parent, this.toPlainName(name, contentReaderExtension));
            nodeReader.parse(resourceUrl, (ContentCreator)contentCreator);
            node = contentCreator.getCreatedRootNode();
        }
        catch (RepositoryException re) {
            try {
                throw re;
                catch (Throwable t) {
                    throw new RepositoryException(t.getMessage(), t);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(contentStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)contentStream);
        return node;
    }

    private Node createFolder(Node parent, String name, boolean overwrite) throws RepositoryException {
        if (parent.hasNode(name)) {
            if (overwrite) {
                parent.getNode(name).remove();
            } else {
                return parent.getNode(name);
            }
        }
        return parent.addNode(name, "sling:Folder");
    }

    private void createFile(PathEntry configuration, Node parent, URL source, List<String> createdNodes, DefaultContentCreator contentCreator) throws IOException, RepositoryException {
        String srcPath = source.getPath();
        int pos = srcPath.lastIndexOf("/");
        String name = this.getName(source.getPath());
        String path = pos == -1 ? name : srcPath.substring(0, pos + 1) + name;
        contentCreator.init(configuration, this.getContentReaders(), createdNodes, null);
        contentCreator.prepareParsing(parent, name);
        URLConnection conn = source.openConnection();
        long lastModified = Math.min(conn.getLastModified(), configuration.getLastModified());
        String type = conn.getContentType();
        InputStream data = conn.getInputStream();
        contentCreator.createFileAndResourceNode(path, data, type, lastModified);
        contentCreator.finishNode();
        contentCreator.finishNode();
    }

    private String getName(String path) {
        String name;
        int lastSlash = path.lastIndexOf(47);
        String string = name = lastSlash < 0 ? path : path.substring(lastSlash + 1);
        if (name.indexOf(37) >= 0) {
            try {
                return URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                this.log.error("Cannot decode " + name + " because the platform has no support for UTF-8, using undecoded");
            }
            catch (Exception e) {
                this.log.error("Cannot decode " + name + ", using undecoded", (Throwable)e);
            }
        }
        return name;
    }

    private Node getTargetNode(Session session, String path) throws RepositoryException {
        if (path == null) {
            return session.getRootNode();
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!session.itemExists(path)) {
            Node currentNode = session.getRootNode();
            StringTokenizer st = new StringTokenizer(path.substring(1), "/");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                if (!currentNode.hasNode(name)) {
                    currentNode.addNode(name, "sling:Folder");
                }
                currentNode = currentNode.getNode(name);
            }
            return currentNode;
        }
        Item item = session.getItem(path);
        return item.isNode() ? (Node)item : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void uninstallContent(Session defaultSession, Bundle bundle, String[] uninstallPaths) {
        block28: {
            HashMap<String, Session> createdSessions = new HashMap<String, Session>();
            this.log.debug("Uninstalling initial content from bundle {}", (Object)bundle.getSymbolicName());
            if (uninstallPaths != null && uninstallPaths.length > 0) {
                for (String path : uninstallPaths) {
                    Session targetSession;
                    int wsSepPos = path.indexOf(":/");
                    if (wsSepPos != -1) {
                        String workspaceName = path.substring(0, wsSepPos);
                        path = path.substring(wsSepPos + 1);
                        if (workspaceName.equals(defaultSession.getWorkspace().getName())) {
                            targetSession = defaultSession;
                        } else if (createdSessions.containsKey(workspaceName)) {
                            targetSession = (Session)createdSessions.get(workspaceName);
                        } else {
                            targetSession = this.createSession(workspaceName);
                            createdSessions.put(workspaceName, targetSession);
                        }
                    } else {
                        targetSession = defaultSession;
                    }
                    if (!targetSession.itemExists(path)) continue;
                    targetSession.getItem(path).remove();
                }
                defaultSession.save();
                for (Session session : createdSessions.values()) {
                    session.save();
                }
            }
            this.log.debug("Done uninstalling initial content from bundle {}", (Object)bundle.getSymbolicName());
            try {
                if (defaultSession.hasPendingChanges()) {
                    defaultSession.refresh(false);
                }
                for (Session session : createdSessions.values()) {
                    if (!session.hasPendingChanges()) continue;
                    session.refresh(false);
                }
            }
            catch (RepositoryException re) {
                this.log.warn("Failure to rollback uninstalling initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re);
            }
            for (Session session : createdSessions.values()) {
                session.logout();
            }
            break block28;
            catch (RepositoryException re4) {
                this.log.error("Unable to uninstall initial content from bundle " + bundle.getSymbolicName(), (Throwable)re4);
                try {
                    if (defaultSession.hasPendingChanges()) {
                        defaultSession.refresh(false);
                    }
                    for (Session session : createdSessions.values()) {
                        if (!session.hasPendingChanges()) continue;
                        session.refresh(false);
                    }
                }
                catch (RepositoryException re2) {
                    this.log.warn("Failure to rollback uninstalling initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re2);
                }
                for (Session session : createdSessions.values()) {
                    session.logout();
                }
                catch (Throwable throwable) {
                    try {
                        if (defaultSession.hasPendingChanges()) {
                            defaultSession.refresh(false);
                        }
                        for (Session session : createdSessions.values()) {
                            if (!session.hasPendingChanges()) continue;
                            session.refresh(false);
                        }
                    }
                    catch (RepositoryException re3) {
                        this.log.warn("Failure to rollback uninstalling initial content for bundle {}", (Object)bundle.getSymbolicName(), (Object)re3);
                    }
                    for (Session session : createdSessions.values()) {
                        session.logout();
                    }
                    throw throwable;
                }
            }
        }
    }

    private Descriptor getParentNodeDescriptor(Bundle bundle, String path, DefaultContentCreator contentCreator) {
        for (Map.Entry<String, ContentReader> entry : contentCreator.getContentReaders().entrySet()) {
            if (entry.getValue() == null) continue;
            StringBuilder filePath = new StringBuilder(path);
            if (!path.endsWith("/")) {
                filePath.append("/");
            }
            filePath.append(PARENT_DESCRIPTOR);
            filePath.append(entry.getKey());
            URL url = bundle.getEntry(filePath.toString());
            if (url == null) continue;
            Descriptor descriptor = new Descriptor();
            descriptor.url = url;
            descriptor.contentReader = entry.getValue();
            return descriptor;
        }
        return null;
    }

    private URL importParentNode(Bundle bundle, String path, Node parent, DefaultContentCreator contentCreator) throws RepositoryException {
        Descriptor descriptor = this.getParentNodeDescriptor(bundle, path, contentCreator);
        if (descriptor == null) {
            return null;
        }
        try {
            contentCreator.prepareParsing(parent, null);
            descriptor.contentReader.parse(descriptor.url, (ContentCreator)contentCreator);
            return descriptor.url;
        }
        catch (RepositoryException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RepositoryException(t.getMessage(), t);
        }
    }

    private Session createSession(String workspace) throws RepositoryException {
        try {
            return this.bundleHelper.getSession(workspace);
        }
        catch (NoSuchWorkspaceException e) {
            Session temp = this.bundleHelper.getSession();
            temp.getWorkspace().createWorkspace(workspace);
            temp.logout();
            return this.bundleHelper.getSession(workspace);
        }
    }

    protected static final class Descriptor {
        public URL url;
        public ContentReader contentReader;

        protected Descriptor() {
        }
    }
}

