/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrXmlImporter {
    private final Logger logger = LoggerFactory.getLogger(JcrXmlImporter.class);

    protected Node importJcrXml(Node parent, String name, InputStream contentStream, boolean replace) throws IOException {
        try {
            String nodeName;
            String string = nodeName = name.endsWith(".jcr.xml") ? name.substring(0, name.length() - ".jcr.xml".length()) : name;
            if (nodeName.length() == 0) {
                throw new IOException("Node name must not be empty (or extension only)");
            }
            if (parent.hasNode(nodeName)) {
                Node existingNode = parent.getNode(nodeName);
                if (replace) {
                    this.logger.debug("importJcrXml: Removing existing node at {}", (Object)nodeName);
                    existingNode.remove();
                } else {
                    this.logger.debug("importJcrXml: Node {} for XML already exists, nothing to to", (Object)nodeName);
                    return existingNode;
                }
            }
            int uuidBehavior = replace ? 2 : 0;
            Session session = parent.getSession();
            session.importXML(parent.getPath(), contentStream, uuidBehavior);
            return parent.hasNode(nodeName) ? parent.getNode(nodeName) : null;
        }
        catch (InvalidSerializedDataException isde) {
            this.logger.info("importJcrXml: XML does not seem to be system or document view; cause: {}", (Object)isde.toString());
            return null;
        }
        catch (RepositoryException re) {
            this.logger.info("importJcrXml: Repository issue loading XML; cause: {}", (Object)re.toString());
            return null;
        }
    }
}

