/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.apache.sling.jcr.contentloader.ContentImportListener;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.apache.sling.jcr.contentloader.ContentTypeUtil;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.apache.sling.jcr.contentloader.internal.BaseImportLoader;
import org.apache.sling.jcr.contentloader.internal.ContentHelper;
import org.apache.sling.jcr.contentloader.internal.ContentReaderWhiteboard;
import org.apache.sling.jcr.contentloader.internal.DefaultContentCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ContentImporter.class})
@Property(name="service.description", value={"Apache Sling JCR Content Import Service"})
@Reference(name="contentReaderWhiteboard", cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC, referenceInterface=ContentReaderWhiteboard.class)
public class DefaultContentImporter
extends BaseImportLoader
implements ContentHelper,
ContentImporter {
    @Reference
    private MimeTypeService mimeTypeService;
    private final Logger logger = LoggerFactory.getLogger(DefaultContentImporter.class);

    @Override
    public void importContent(Node parent, String filename, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws RepositoryException, IOException {
        if (filename.endsWith(".jcr.xml")) {
            this.importJcrXml(parent, filename, contentStream, importOptions, importListener);
            return;
        }
        DefaultContentCreator contentCreator = new DefaultContentCreator(this);
        String readerExtension = this.getContentReaderExtension(filename);
        String name = this.toPlainName(filename, readerExtension);
        ContentReader contentReader = this.getContentReader(filename, importOptions);
        this.importContent(contentCreator, contentReader, parent, name, contentStream, importOptions, importListener);
    }

    @Override
    public void importContent(Node parent, String name, String contentType, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws RepositoryException, IOException {
        if ("application/x-jcr+xml".equalsIgnoreCase(contentType)) {
            this.importJcrXml(parent, name, contentStream, importOptions, importListener);
            return;
        }
        DefaultContentCreator contentCreator = new DefaultContentCreator(this);
        String extension = ContentTypeUtil.getDefaultExtension(contentType);
        ContentReader contentReader = this.getContentReader(extension, importOptions);
        this.importContent(contentCreator, contentReader, parent, name, contentStream, importOptions, importListener);
    }

    private void importContent(DefaultContentCreator contentCreator, ContentReader contentReader, Node parent, String name, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws RepositoryException, IOException {
        ArrayList<String> createdPaths = new ArrayList<String>();
        contentCreator.init(importOptions, this.getContentReaders(), createdPaths, importListener);
        contentCreator.prepareParsing(parent, name);
        contentReader.parse(contentStream, (ContentCreator)contentCreator);
        Session session = parent.getSession();
        session.save();
        for (Node versionable : contentCreator.getVersionables()) {
            versionable.checkin();
            if (importListener == null) continue;
            importListener.onCheckin(versionable.getPath());
        }
    }

    private void importJcrXml(Node parent, String name, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws IOException, RepositoryException {
        this.logger.debug("import JCR XML: '{}'", (Object)name);
        boolean replace = importOptions == null ? false : importOptions.isOverwrite();
        Node node = this.importJcrXml(parent, name, contentStream, replace);
        if (node != null && importListener != null) {
            importListener.onCreate(node.getPath());
        }
    }

    @Override
    public String getMimeType(String name) {
        MimeTypeService mts = this.mimeTypeService;
        return mts != null ? mts.getMimeType(name) : null;
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

