/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.contentloader.ContentReader;

@Component
@Service(value={ContentReaderWhiteboard.class})
@References(value={@Reference(name="contentReader", referenceInterface=ContentReader.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class ContentReaderWhiteboard {
    private Map<String, ContentReader> readersByExtension = new LinkedHashMap<String, ContentReader>();
    private Map<String, ContentReader> readersByType = new LinkedHashMap<String, ContentReader>();

    public Map<String, ContentReader> getReadersByExtension() {
        return this.readersByExtension;
    }

    public Map<String, ContentReader> getReadersByType() {
        return this.readersByType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindContentReader(ContentReader operation, Map<String, Object> properties) {
        Map<String, ContentReader> map;
        String[] extensions = PropertiesUtil.toStringArray((Object)properties.get("extensions"));
        String[] types = PropertiesUtil.toStringArray((Object)properties.get("contentTypes"));
        if (extensions != null) {
            map = this.readersByExtension;
            synchronized (map) {
                for (String extension : extensions) {
                    this.readersByExtension.put(extension, operation);
                }
            }
        }
        if (types != null) {
            map = this.readersByType;
            synchronized (map) {
                for (String type : types) {
                    this.readersByType.put(type, operation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindContentReader(ContentReader operation, Map<String, Object> properties) {
        Map<String, ContentReader> map;
        String[] extensions = PropertiesUtil.toStringArray((Object)properties.get("extensions"));
        String[] types = PropertiesUtil.toStringArray((Object)properties.get("contentTypes"));
        if (this.readersByExtension != null && extensions != null) {
            map = this.readersByExtension;
            synchronized (map) {
                for (String extension : extensions) {
                    this.readersByExtension.remove(extension);
                }
            }
        }
        if (types != null) {
            map = this.readersByType;
            synchronized (map) {
                for (String type : types) {
                    this.readersByType.remove(type);
                }
            }
        }
    }
}

