/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.classloader.internal;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.classloader.DynamicClassLoader;
import org.apache.sling.jcr.classloader.internal.ClassLoaderWriterImpl;
import org.apache.sling.jcr.classloader.internal.Util;
import org.apache.sling.jcr.classloader.internal.net.JCRURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryClassLoader
extends SecureClassLoader
implements DynamicClassLoader {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Set<String> usedResources = new HashSet<String>();
    private volatile boolean dirty = false;
    private final String repositoryPath;
    private final ClassLoaderWriterImpl writer;
    private volatile boolean destroyed = false;

    public RepositoryClassLoader(String classPath, ClassLoaderWriterImpl writer, ClassLoader parent) {
        super(parent);
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        if (classPath == null) {
            throw new NullPointerException("classPath");
        }
        this.writer = writer;
        this.repositoryPath = classPath;
        this.logger.debug("RepositoryClassLoader: {} ready", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.destroyed) {
            this.logger.debug("Instance is already destroyed");
            return;
        }
        this.destroyed = true;
        Set<String> set = this.usedResources;
        synchronized (set) {
            this.usedResources.clear();
        }
    }

    @Override
    protected Class<?> findClass(final String name) throws ClassNotFoundException {
        if (!this.writer.isActivate()) {
            throw new ClassNotFoundException(name + " (Classloader destroyed)");
        }
        this.logger.debug("findClass: Try to find class {}", (Object)name);
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return RepositoryClassLoader.this.findClassPrivileged(name);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    @Override
    public URL findResource(String name) {
        if (!this.writer.isActivate()) {
            this.logger.warn("Destroyed class loader cannot find a resource: " + name, (Throwable)new IllegalStateException());
            return null;
        }
        this.logger.debug("findResource: Try to find resource {}", (Object)name);
        String path = this.repositoryPath + '/' + name;
        try {
            if (this.findClassLoaderResource(path)) {
                this.logger.debug("findResource: Getting resource from {}", (Object)path);
                return JCRURLHandler.createURL(this.writer, path);
            }
        }
        catch (Exception e) {
            this.logger.warn("findResource: Cannot getURL for " + name, (Throwable)e);
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        if (!this.writer.isActivate()) {
            this.logger.warn("Destroyed class loader cannot find a resources: " + name, (Throwable)new IllegalStateException());
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public URL nextElement() {
                    throw new NoSuchElementException("No Entries");
                }
            };
        }
        this.logger.debug("findResources: Try to find resources for {}", (Object)name);
        URL url = this.findResource(name);
        List<URL> list = Collections.singletonList(url);
        if (url != null) {
            list.add(url);
        }
        return Collections.enumeration(list);
    }

    private Class<?> findClassPrivileged(String name) throws ClassNotFoundException {
        this.logger.debug("findClassPrivileged: Try to find path {class {}", (Object)name);
        String path = this.repositoryPath + '/' + name.replace('.', '/') + ".class";
        try {
            byte[] data = this.findClassLoaderClass(path);
            if (data != null) {
                this.logger.debug("findClassPrivileged: Loading class from {} bytes", (Object)data.length);
                Class<?> c = this.defineClass(name, data);
                if (c == null) {
                    this.logger.warn("defineClass returned null for class {}", (Object)name);
                    throw new ClassNotFoundException(name);
                }
                return c;
            }
        }
        catch (IOException ioe) {
            this.logger.debug("defineClass failed", (Throwable)ioe);
            throw new ClassNotFoundException(name, ioe);
        }
        catch (Throwable t) {
            this.logger.debug("defineClass failed", t);
            throw new ClassNotFoundException(name, t);
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findClassLoaderResource(String path) throws IOException {
        Session session = null;
        boolean res = false;
        try {
            session = this.writer.createSession();
            if (session.itemExists(path)) {
                this.logger.debug("Found resource at {}", (Object)path);
                res = true;
            } else {
                this.logger.debug("No classpath entry contains {}", (Object)path);
            }
        }
        catch (RepositoryException re) {
            this.logger.debug("Error while trying to get node at " + path, (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] findClassLoaderClass(String path) throws IOException {
        Session session = null;
        byte[] res = null;
        try {
            session = this.writer.createSession();
            if (session.itemExists(path)) {
                Node node = (Node)session.getItem(path);
                this.logger.debug("Found resource at {}", (Object)path);
                res = Util.getBytes(node);
            } else {
                this.logger.debug("No classpath entry contains {}", (Object)path);
            }
        }
        catch (RepositoryException re) {
            this.logger.debug("Error while trying to get node at " + path, (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        if (!this.dirty) {
            Set<String> set = this.usedResources;
            synchronized (set) {
                this.usedResources.add(path);
            }
        }
        return res;
    }

    private Class<?> defineClass(String name, byte[] contents) {
        this.logger.debug("defineClass({}, {})", (Object)name, (Object)contents.length);
        Class<?> clazz = this.defineClass(name, contents, 0, contents.length);
        return clazz;
    }

    public boolean isLive() {
        return !this.destroyed && !this.dirty && this.writer.isActivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(String path) {
        Set<String> set = this.usedResources;
        synchronized (set) {
            if (this.usedResources.contains(path)) {
                this.logger.debug("handleEvent: Item {} has been modified - marking class loader as dirty {}", (Object)path, (Object)this);
                this.dirty = true;
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        if (this.destroyed) {
            buf.append(" - destroyed");
        } else {
            buf.append(": parent: { ");
            buf.append(this.getParent());
            buf.append(" }, live: ");
            buf.append(this.isLive());
        }
        return buf.toString();
    }
}

