/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.classloader.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.classloader.internal.RepositoryClassLoader;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%loader.name", description="%loader.description", name="org.apache.sling.jcr.classloader.internal.DynamicClassLoaderProviderImpl")
@Service(value={ClassLoaderWriter.class}, serviceFactory=true)
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Repository based classloader writer"})})
public class ClassLoaderWriterImpl
implements ClassLoaderWriter {
    private final Logger logger = LoggerFactory.getLogger(ClassLoaderWriterImpl.class);
    private static final String CLASS_PATH_DEFAULT = "/var/classes";
    @Property(value={"/var/classes"})
    private static final String CLASS_PATH_PROP = "classpath";
    private static final boolean APPEND_ID_DEFAULT = true;
    @Property(boolValue={true})
    private static final String APPEND_ID_PROP = "appendId";
    private static final String NT_FOLDER = "nt:folder";
    private static final String OWNER_DEFAULT = "admin";
    @Property(value={"admin"})
    private static final String OWNER_PROP = "owner";
    @Reference
    private SlingSettingsService settings;
    private String classLoaderOwner;
    private String classPath;
    @Reference
    private SlingRepository repository;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private volatile MimeTypeService mimeTypeService;
    @Reference(referenceInterface=DynamicClassLoaderManager.class, bind="bindDynamicClassLoaderManager", unbind="unbindDynamicClassLoaderManager")
    private volatile ServiceReference dynamicClassLoaderManager;
    private Bundle callerBundle;
    private volatile RepositoryClassLoader repositoryClassLoader;

    @Activate
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        this.classPath = PropertiesUtil.toString((Object)properties.get(CLASS_PATH_PROP), (String)CLASS_PATH_DEFAULT);
        if (this.classPath.endsWith("/")) {
            this.classPath = this.classPath.substring(0, this.classPath.length() - 1);
        }
        if (PropertiesUtil.toBoolean((Object)properties.get(APPEND_ID_PROP), (boolean)true)) {
            this.classPath = this.classPath + '/' + this.settings.getSlingId();
        }
        this.classLoaderOwner = PropertiesUtil.toString((Object)properties.get(OWNER_PROP), (String)OWNER_DEFAULT);
        this.callerBundle = componentContext.getUsingBundle();
    }

    @Deactivate
    protected synchronized void deactivate() {
        this.destroyRepositoryClassLoader();
        this.callerBundle = null;
    }

    private void bindDynamicClassLoaderManager(ServiceReference ref) {
        this.dynamicClassLoaderManager = ref;
    }

    private void unbindDynamicClassLoaderManager(ServiceReference ref) {
        if (this.dynamicClassLoaderManager == ref) {
            this.dynamicClassLoaderManager = null;
        }
    }

    private void destroyRepositoryClassLoader() {
        RepositoryClassLoader rcl = this.repositoryClassLoader;
        if (rcl != null) {
            this.repositoryClassLoader = null;
            rcl.destroy();
            ServiceReference localDynamicClassLoaderManager = this.dynamicClassLoaderManager;
            Bundle localCallerBundle = this.callerBundle;
            if (localDynamicClassLoaderManager != null && localCallerBundle != null) {
                localCallerBundle.getBundleContext().ungetService(localDynamicClassLoaderManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession() throws RepositoryException {
        Session admin = this.repository.loginAdministrative(null);
        if (admin.getUserID().equals(this.classLoaderOwner)) {
            return admin;
        }
        try {
            Session session = admin.impersonate((Credentials)new SimpleCredentials(this.classLoaderOwner, new char[0]));
            return session;
        }
        finally {
            admin.logout();
        }
    }

    public boolean isActivate() {
        return this.repository != null;
    }

    private synchronized RepositoryClassLoader getOrCreateClassLoader() {
        if (this.repositoryClassLoader == null || !this.repositoryClassLoader.isLive()) {
            this.destroyRepositoryClassLoader();
            DynamicClassLoaderManager dclm = (DynamicClassLoaderManager)this.callerBundle.getBundleContext().getService(this.dynamicClassLoaderManager);
            this.repositoryClassLoader = new RepositoryClassLoader(this.classPath, this, dclm.getDynamicClassLoader());
        }
        return this.repositoryClassLoader;
    }

    private synchronized void handleChangeEvent(String path) {
        RepositoryClassLoader rcl = this.repositoryClassLoader;
        if (rcl != null) {
            rcl.handleEvent(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String name) {
        String path = this.cleanPath(name);
        this.handleChangeEvent(path);
        Session session = null;
        try {
            session = this.createSession();
            if (session.itemExists(path)) {
                Item fileItem = session.getItem(path);
                fileItem.remove();
                session.save();
                boolean bl = true;
                return bl;
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Cannot remove " + path, (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return false;
    }

    public OutputStream getOutputStream(String name) {
        String path = this.cleanPath(name);
        return new RepositoryOutputStream(this, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String oldName, String newName) {
        String oldPath = this.cleanPath(oldName);
        String newPath = this.cleanPath(newName);
        Session session = null;
        try {
            session = this.createSession();
            session.move(oldPath, newPath);
            session.save();
            this.handleChangeEvent(oldName);
            this.handleChangeEvent(newName);
            boolean bl = true;
            return bl;
        }
        catch (RepositoryException re) {
            this.logger.error("Cannot rename " + oldName + " to " + newName, (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return false;
    }

    private synchronized boolean mkdirs(Session session, String path) {
        try {
            if (session.itemExists(path) && session.getItem(path).isNode()) {
                return true;
            }
            Node current = session.getRootNode();
            String[] names = path.split("/");
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null || names[i].length() == 0) continue;
                if (current.hasNode(names[i])) {
                    current = current.getNode(names[i]);
                    continue;
                }
                Node parentNode = current;
                try {
                    current = parentNode.addNode(names[i], NT_FOLDER);
                    session.save();
                    continue;
                }
                catch (RepositoryException re) {
                    session.refresh(false);
                    if (parentNode.hasNode(names[i])) {
                        current = parentNode.getNode(names[i]);
                        continue;
                    }
                    current = parentNode.addNode(names[i], NT_FOLDER);
                    session.save();
                }
            }
            return true;
        }
        catch (RepositoryException re) {
            this.logger.error("Cannot create folder path:" + path, (Throwable)re);
            try {
                session.refresh(false);
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            return false;
        }
    }

    private String cleanPath(String path) {
        path = path.replace('\\', '/');
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return this.classPath + path;
    }

    public InputStream getInputStream(String name) throws IOException {
        String path = this.cleanPath(name) + "/jcr:content/jcr:data";
        Session session = null;
        try {
            session = this.createSession();
            if (session.itemExists(path)) {
                javax.jcr.Property prop = (javax.jcr.Property)session.getItem(path);
                InputStream is = prop.getStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int l = 0;
                byte[] buf = new byte[2048];
                while ((l = is.read(buf)) > -1) {
                    if (l <= 0) continue;
                    baos.write(buf, 0, l);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                return byteArrayInputStream;
            }
            try {
                throw new FileNotFoundException("Unable to find " + name);
            }
            catch (RepositoryException re) {
                throw (IOException)new IOException("Failed to get InputStream for " + name).initCause(re);
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(String name) {
        String path = this.cleanPath(name) + "/jcr:content/jcr:lastModified";
        Session session = null;
        try {
            session = this.createSession();
            if (session.itemExists(path)) {
                javax.jcr.Property prop = (javax.jcr.Property)session.getItem(path);
                long l = prop.getLong();
                return l;
            }
        }
        catch (RepositoryException se) {
            this.logger.error("Cannot get last modification time for " + name, (Throwable)se);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return -1L;
    }

    public ClassLoader getClassLoader() {
        return this.getOrCreateClassLoader();
    }

    protected void bindSettings(SlingSettingsService slingSettingsService) {
        this.settings = slingSettingsService;
    }

    protected void unbindSettings(SlingSettingsService slingSettingsService) {
        if (this.settings == slingSettingsService) {
            this.settings = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    private static class RepositoryOutputStream
    extends ByteArrayOutputStream {
        private final ClassLoaderWriterImpl repositoryOutputProvider;
        private final String fileName;

        RepositoryOutputStream(ClassLoaderWriterImpl repositoryOutputProvider, String fileName) {
            this.repositoryOutputProvider = repositoryOutputProvider;
            this.fileName = fileName;
        }

        public void close() throws IOException {
            super.close();
            Session session = null;
            try {
                MimeTypeService mtService;
                String mimeType;
                String name;
                session = this.repositoryOutputProvider.createSession();
                int lastPos = this.fileName.lastIndexOf(47);
                String path = lastPos == -1 ? null : this.fileName.substring(0, lastPos);
                String string = name = lastPos == -1 ? this.fileName : this.fileName.substring(lastPos + 1);
                if (lastPos != -1 && !this.repositoryOutputProvider.mkdirs(session, path)) {
                    throw new IOException("Unable to create path for " + path);
                }
                Node fileNode = null;
                Node contentNode = null;
                Node parentNode = null;
                if (session.itemExists(this.fileName)) {
                    Item item = session.getItem(this.fileName);
                    if (item.isNode()) {
                        Node node;
                        Node node2 = node = item.isNode() ? (Node)item : item.getParent();
                        if ("jcr:content".equals(node.getName())) {
                            parentNode = node;
                            contentNode = node;
                        } else if (node.isNodeType("nt:file")) {
                            parentNode = node;
                            contentNode = node.getNode("jcr:content");
                        } else {
                            parentNode = node;
                            contentNode = node;
                        }
                    } else {
                        parentNode = item.getParent();
                        item.remove();
                        session.save();
                        fileNode = parentNode.addNode(name, "nt:file");
                    }
                } else {
                    if (lastPos <= 0) {
                        parentNode = session.getRootNode();
                    } else {
                        Item parent = session.getItem(path);
                        if (!parent.isNode()) {
                            throw new IOException("Parent at " + path + " is not a node.");
                        }
                        parentNode = (Node)parent;
                    }
                    fileNode = parentNode.addNode(name, "nt:file");
                }
                if (fileNode != null) {
                    contentNode = fileNode.addNode("jcr:content", "nt:resource");
                }
                String string2 = mimeType = (mtService = this.repositoryOutputProvider.mimeTypeService) == null ? null : mtService.getMimeType(this.fileName);
                if (mimeType == null) {
                    mimeType = "application/octet-stream";
                }
                contentNode.setProperty("jcr:lastModified", System.currentTimeMillis());
                contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(this.buf, 0, this.size()));
                contentNode.setProperty("jcr:mimeType", mimeType);
                session.save();
                this.repositoryOutputProvider.handleChangeEvent(this.fileName);
            }
            catch (RepositoryException re) {
                throw (IOException)new IOException("Cannot write file " + this.fileName + ", reason: " + re.toString()).initCause(re);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }
}

