/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.sling.jcr.base.internal.mount.ProxyAccessControlManager;
import org.apache.sling.jcr.base.internal.mount.ProxySession;

public class ProxyJackrabbitAccessControlManager
extends ProxyAccessControlManager<JackrabbitAccessControlManager>
implements JackrabbitAccessControlManager {
    public ProxyJackrabbitAccessControlManager(ProxySession<?> mountSession, JackrabbitAccessControlManager delegate, JackrabbitAccessControlManager mount) {
        super(mountSession, delegate, mount);
    }

    public JackrabbitAccessControlPolicy[] getApplicablePolicies(Principal principal) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        ArrayList<JackrabbitAccessControlPolicy> result = new ArrayList<JackrabbitAccessControlPolicy>();
        result.addAll(Arrays.asList(((JackrabbitAccessControlManager)this.delegate).getApplicablePolicies(principal)));
        result.addAll(Arrays.asList(((JackrabbitAccessControlManager)this.mount).getApplicablePolicies(principal)));
        return result.toArray(new JackrabbitAccessControlPolicy[0]);
    }

    public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        ArrayList<JackrabbitAccessControlPolicy> result = new ArrayList<JackrabbitAccessControlPolicy>();
        result.addAll(Arrays.asList(((JackrabbitAccessControlManager)this.delegate).getPolicies(principal)));
        result.addAll(Arrays.asList(((JackrabbitAccessControlManager)this.mount).getPolicies(principal)));
        return result.toArray(new JackrabbitAccessControlPolicy[0]);
    }

    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        ArrayList<AccessControlPolicy> result = new ArrayList<AccessControlPolicy>();
        result.addAll(Arrays.asList(((JackrabbitAccessControlManager)this.delegate).getEffectivePolicies(principals)));
        result.addAll(Arrays.asList(((JackrabbitAccessControlManager)this.mount).getEffectivePolicies(principals)));
        return result.toArray(new AccessControlPolicy[0]);
    }

    public boolean hasPrivileges(String absPath, Set<Principal> principals, Privilege[] privileges) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (this.mountSession.isMount(absPath)) {
            return ((JackrabbitAccessControlManager)this.mount).hasPrivileges(absPath, principals, privileges);
        }
        return ((JackrabbitAccessControlManager)this.delegate).hasPrivileges(absPath, principals, privileges);
    }

    public Privilege[] getPrivileges(String absPath, Set<Principal> principals) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (this.mountSession.isMount(absPath)) {
            return ((JackrabbitAccessControlManager)this.mount).getPrivileges(absPath, principals);
        }
        return ((JackrabbitAccessControlManager)this.delegate).getPrivileges(absPath, principals);
    }
}

