/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.jcr.base.internal.Configuration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;

@Component(configurationPid={"org.apache.sling.jcr.base.internal.LoginAdminWhitelist.fragment"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={WhitelistFragment.class})
@Designate(ocd=Configuration.class, factory=true)
public class WhitelistFragment {
    private String name;
    private Set<String> bundles;

    public WhitelistFragment() {
    }

    WhitelistFragment(String name, String[] bundles) {
        this.name = name;
        this.bundles = this.asSet(bundles);
    }

    @Activate
    void activate(Configuration config) {
        this.name = config.whitelist_name();
        this.bundles = this.asSet(config.whitelist_bundles());
    }

    boolean allows(String bsn) {
        return this.bundles.contains(bsn);
    }

    public String toString() {
        return this.name + ": " + this.bundles + "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WhitelistFragment)) {
            return false;
        }
        WhitelistFragment that = (WhitelistFragment)o;
        return this.name.equals(that.name) && this.bundles.equals(that.bundles);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.bundles.hashCode();
        return result;
    }

    private Set<String> asSet(String[] values) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(values)));
    }
}

