/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.base.internal.LoginAdminWhitelistConfiguration;
import org.apache.sling.jcr.base.internal.WhitelistFragment;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={LoginAdminWhitelist.class}, property={"service.description=Apache Sling Login Admin Whitelist", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=LoginAdminWhitelistConfiguration.class)
public class LoginAdminWhitelist {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAdminWhitelist.class);
    private volatile ConfigurationState config;
    private final List<WhitelistFragment> whitelistFragments = new CopyOnWriteArrayList<WhitelistFragment>();
    private static final String PROP_WHITELIST_BUNDLES_DEFAULT = "whitelist.bundles.default";
    private static final String PROP_WHITELIST_BUNDLES_ADDITIONAL = "whitelist.bundles.additional";
    private final Map<String, WhitelistFragment> backwardsCompatibleFragments = new ConcurrentHashMap<String, WhitelistFragment>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void bindWhitelistFragment(WhitelistFragment fragment) {
        this.whitelistFragments.add(fragment);
        LOG.info("WhitelistFragment added '{}'", (Object)fragment);
    }

    void unbindWhitelistFragment(WhitelistFragment fragment) {
        this.whitelistFragments.remove(fragment);
        LOG.info("WhitelistFragment removed '{}'", (Object)fragment);
    }

    @Activate
    @Modified
    void configure(LoginAdminWhitelistConfiguration configuration, Map<String, Object> properties) {
        this.config = new ConfigurationState(configuration);
        this.ensureBackwardsCompatibility(properties, PROP_WHITELIST_BUNDLES_DEFAULT);
        this.ensureBackwardsCompatibility(properties, PROP_WHITELIST_BUNDLES_ADDITIONAL);
    }

    public boolean allowLoginAdministrative(Bundle b) {
        if (this.config == null) {
            throw new IllegalStateException("LoginAdminWhitelist has no configuration.");
        }
        ConfigurationState localConfig = this.config;
        if (localConfig.bypassWhitelist) {
            LOG.debug("Whitelist is bypassed, all bundles allowed to use loginAdministrative");
            return true;
        }
        String bsn = b.getSymbolicName();
        if (localConfig.whitelistRegexp != null && localConfig.whitelistRegexp.matcher(bsn).matches()) {
            LOG.debug("{} is whitelisted to use loginAdministrative, by regexp", (Object)bsn);
            return true;
        }
        for (WhitelistFragment fragment : this.whitelistFragments) {
            if (!fragment.allows(bsn)) continue;
            LOG.debug("{} is whitelisted to use loginAdministrative, by whitelist fragment '{}'", (Object)bsn, (Object)fragment);
            return true;
        }
        LOG.debug("{} is not whitelisted to use loginAdministrative", (Object)bsn);
        return false;
    }

    private void ensureBackwardsCompatibility(Map<String, Object> properties, String propertyName) {
        WhitelistFragment oldFragment = this.backwardsCompatibleFragments.remove(propertyName);
        String[] bsns = PropertiesUtil.toStringArray((Object)properties.get(propertyName), (String[])new String[0]);
        if (bsns.length != 0) {
            LOG.warn("Using deprecated configuration property '{}'", (Object)propertyName);
            WhitelistFragment fragment = new WhitelistFragment("deprecated-" + propertyName, bsns);
            this.bindWhitelistFragment(fragment);
            this.backwardsCompatibleFragments.put(propertyName, fragment);
        }
        if (oldFragment != null) {
            this.unbindWhitelistFragment(oldFragment);
        }
    }

    private static class ConfigurationState {
        private final boolean bypassWhitelist;
        private final Pattern whitelistRegexp;

        private ConfigurationState(LoginAdminWhitelistConfiguration config) {
            String regexp = config.whitelist_bundles_regexp();
            if (regexp.trim().length() > 0) {
                this.whitelistRegexp = Pattern.compile(regexp);
                LOG.warn("A 'whitelist.bundles.regexp' is configured, this is NOT RECOMMENDED for production: {}", (Object)this.whitelistRegexp);
            } else {
                this.whitelistRegexp = null;
            }
            this.bypassWhitelist = config.whitelist_bypass();
            if (this.bypassWhitelist) {
                LOG.info("bypassWhitelist=true, whitelisted BSNs=<ALL>");
                LOG.warn("All bundles are allowed to use loginAdministrative due to the 'whitelist.bypass' configuration of this service. This is NOT RECOMMENDED, for security reasons.");
            }
        }
    }
}

