/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Repository;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.jcr.base.AbstractSlingRepository2;
import org.apache.sling.jcr.base.internal.LoginAdminWhitelist;
import org.apache.sling.jcr.base.internal.loader.Loader;
import org.apache.sling.jcr.base.internal.mount.ProxyJackrabbitRepository;
import org.apache.sling.jcr.base.internal.mount.ProxyRepository;
import org.apache.sling.jcr.base.spi.RepositoryMount;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public abstract class AbstractSlingRepositoryManager {
    private static final AtomicInteger startupCounter = new AtomicInteger();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile BundleContext bundleContext;
    private volatile Repository repository;
    private volatile AbstractSlingRepository2 masterSlingRepository;
    private volatile ServiceRegistration repositoryService;
    private volatile String defaultWorkspace;
    private volatile boolean disableLoginAdministrative;
    private volatile ServiceTracker<SlingRepositoryInitializer, SlingRepositoryInitializerInfo> repoInitializerTracker;
    private volatile Loader loader;
    private volatile ServiceTracker<LoginAdminWhitelist, LoginAdminWhitelist> whitelistTracker;
    private final Object repoInitLock = new Object();
    private volatile Thread startupThread;
    private volatile boolean stopRequested;
    volatile ServiceTracker<RepositoryMount, RepositoryMount> mountTracker;

    public final String getDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    public final boolean isDisableLoginAdministrative() {
        return this.disableLoginAdministrative;
    }

    protected abstract ServiceUserMapper getServiceUserMapper();

    protected boolean allowLoginAdministrativeForBundle(Bundle bundle) {
        return ((LoginAdminWhitelist)this.whitelistTracker.getService()).allowLoginAdministrative(bundle);
    }

    protected abstract Repository acquireRepository();

    protected final ServiceRegistration registerService() {
        Dictionary<String, Object> props = this.getServiceRegistrationProperties();
        String[] interfaces = this.getServiceRegistrationInterfaces();
        return this.bundleContext.registerService(interfaces, (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return AbstractSlingRepositoryManager.this.create(bundle);
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                AbstractSlingRepositoryManager.this.destroy((AbstractSlingRepository2)service);
            }
        }, props);
    }

    protected abstract Dictionary<String, Object> getServiceRegistrationProperties();

    protected String[] getServiceRegistrationInterfaces() {
        return new String[]{SlingRepository.class.getName(), Repository.class.getName()};
    }

    protected abstract AbstractSlingRepository2 create(Bundle var1);

    protected abstract void destroy(AbstractSlingRepository2 var1);

    protected final Repository getRepository() {
        ServiceReference ref = this.mountTracker != null ? this.mountTracker.getServiceReference() : null;
        Repository mountRepo = ref != null ? (Repository)this.mountTracker.getService(ref) : null;
        Object mounts = ref != null ? ref.getProperty("org.apache.sling.jcr.base.RepositoryMount.MOUNT_POINTS") : null;
        HashSet<String> mountPoints = new HashSet<String>();
        if (mounts != null) {
            if (mounts instanceof String[]) {
                for (String mount : (String[])mounts) {
                    mountPoints.add(mount);
                }
            } else {
                mountPoints.add(mounts.toString());
            }
        } else {
            mountPoints.add("/content/jcrmount");
        }
        return mountRepo != null ? (this.repository instanceof JackrabbitRepository ? new ProxyJackrabbitRepository((JackrabbitRepository)this.repository, (JackrabbitRepository)mountRepo, (Set<String>)mountPoints) : new ProxyRepository<Repository>(this.repository, mountRepo, mountPoints)) : this.repository;
    }

    protected final void unregisterService(ServiceRegistration serviceRegistration) {
        serviceRegistration.unregister();
    }

    protected abstract void disposeRepository(Repository var1);

    @Deprecated
    protected final boolean start(BundleContext bundleContext, String defaultWorkspace, boolean disableLoginAdministrative) {
        this.start(bundleContext, new Config(defaultWorkspace, disableLoginAdministrative));
        long end = System.currentTimeMillis() + 5000L;
        while (!this.isRepositoryServiceRegistered() && end > System.currentTimeMillis()) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return this.isRepositoryServiceRegistered();
    }

    protected final void start(final BundleContext bundleContext, Config config) {
        if (this.bundleContext != null) {
            this.log.debug("start: Repository already started and registered");
            return;
        }
        this.bundleContext = bundleContext;
        this.defaultWorkspace = config.defaultWorkspace;
        this.disableLoginAdministrative = config.disableLoginAdministrative;
        this.mountTracker = new ServiceTracker(this.bundleContext, RepositoryMount.class, null);
        this.mountTracker.open();
        this.repoInitializerTracker = new ServiceTracker(bundleContext, SlingRepositoryInitializer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SlingRepositoryInitializer, SlingRepositoryInitializerInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SlingRepositoryInitializerInfo addingService(ServiceReference<SlingRepositoryInitializer> reference) {
                SlingRepositoryInitializer service = (SlingRepositoryInitializer)bundleContext.getService(reference);
                if (service != null) {
                    SlingRepositoryInitializerInfo info = new SlingRepositoryInitializerInfo(service, reference);
                    Object object = AbstractSlingRepositoryManager.this.repoInitLock;
                    synchronized (object) {
                        if (AbstractSlingRepositoryManager.this.masterSlingRepository != null) {
                            AbstractSlingRepositoryManager.this.log.debug("Executing {}", (Object)info.initializer);
                            try {
                                info.initializer.processRepository((SlingRepository)AbstractSlingRepositoryManager.this.masterSlingRepository);
                            }
                            catch (Exception e) {
                                AbstractSlingRepositoryManager.this.log.error("Exception in a SlingRepositoryInitializer: " + info.initializer, (Throwable)e);
                            }
                        }
                    }
                    return info;
                }
                return null;
            }

            public void modifiedService(ServiceReference<SlingRepositoryInitializer> reference, SlingRepositoryInitializerInfo service) {
            }

            public void removedService(ServiceReference<SlingRepositoryInitializer> reference, SlingRepositoryInitializerInfo service) {
                bundleContext.ungetService(reference);
            }
        });
        this.repoInitializerTracker.open();
        boolean enableWhitelist = !this.isAllowLoginAdministrativeForBundleOverridden();
        final CountDownLatch waitForWhitelist = new CountDownLatch(enableWhitelist ? 1 : 0);
        if (enableWhitelist) {
            this.whitelistTracker = new ServiceTracker<LoginAdminWhitelist, LoginAdminWhitelist>(bundleContext, LoginAdminWhitelist.class, null){

                public LoginAdminWhitelist addingService(ServiceReference<LoginAdminWhitelist> reference) {
                    try {
                        LoginAdminWhitelist loginAdminWhitelist = (LoginAdminWhitelist)super.addingService(reference);
                        return loginAdminWhitelist;
                    }
                    finally {
                        waitForWhitelist.countDown();
                    }
                }
            };
            this.whitelistTracker.open();
        }
        this.startupThread = new Thread("Apache Sling Repository Startup Thread #" + startupCounter.incrementAndGet()){

            @Override
            public void run() {
                try {
                    waitForWhitelist.await();
                    AbstractSlingRepositoryManager.this.initializeAndRegisterRepositoryService();
                }
                catch (InterruptedException e) {
                    AbstractSlingRepositoryManager.this.log.info("Interrupted while waiting for the {} service, cancelling repository initialisation", (Object)LoginAdminWhitelist.class.getSimpleName(), (Object)e);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        };
        this.startupThread.start();
    }

    private boolean isRepositoryServiceRegistered() {
        return this.repositoryService != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAndRegisterRepositoryService() {
        block13: {
            Throwable t = null;
            try {
                this.log.debug("start: calling acquireRepository()");
                Repository newRepo = this.acquireRepository();
                if (newRepo == null) break block13;
                this.log.debug("start: got a Repository");
                this.repository = newRepo;
                if (this.stopRequested) {
                    this.log.debug("Stop requested, cancelling initialisation and stopping repository");
                    this.stop();
                    return;
                }
                Object object = this.repoInitLock;
                synchronized (object) {
                    this.masterSlingRepository = this.create(this.bundleContext.getBundle());
                    this.log.debug("start: setting up Loader");
                    this.loader = new Loader(this.masterSlingRepository, this.bundleContext);
                    this.log.debug("start: calling SlingRepositoryInitializer");
                    try {
                        this.executeRepositoryInitializers(this.masterSlingRepository);
                    }
                    catch (Throwable e) {
                        t = e;
                        this.log.error("Exception in a SlingRepositoryInitializer, SlingRepository service registration aborted", t);
                    }
                    this.log.debug("start: calling registerService()");
                    this.repositoryService = this.registerService();
                    this.log.debug("start: registerService() successful, registration=" + this.repositoryService);
                }
            }
            catch (Throwable e) {
                this.log.error("start: Uncaught Throwable trying to access Repository, calling stopRepository()", e);
                t = e;
            }
            finally {
                if (t != null) {
                    this.stop();
                }
            }
        }
    }

    private boolean isAllowLoginAdministrativeForBundleOverridden() {
        for (Class<?> clazz = this.getClass(); clazz != AbstractSlingRepositoryManager.class; clazz = clazz.getSuperclass()) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                if (!method.getName().equals("allowLoginAdministrativeForBundle") || !Arrays.equals(method.getParameterTypes(), new Class[]{Bundle.class})) continue;
                return true;
            }
        }
        return false;
    }

    private void executeRepositoryInitializers(SlingRepository repo) throws Exception {
        Object[] infos = (SlingRepositoryInitializerInfo[])this.repoInitializerTracker.getServices((Object[])new SlingRepositoryInitializerInfo[0]);
        if (infos == null || infos.length == 0) {
            this.log.debug("No SlingRepositoryInitializer services found");
            return;
        }
        Arrays.sort(infos);
        for (Object info : infos) {
            this.log.debug("Executing {}", (Object)((SlingRepositoryInitializerInfo)info).initializer);
            ((SlingRepositoryInitializerInfo)info).initializer.processRepository(repo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stop() {
        this.stopRequested = true;
        if (this.startupThread != null && this.startupThread != Thread.currentThread()) {
            try {
                this.startupThread.interrupt();
                this.startupThread.join();
            }
            catch (InterruptedException e) {
                this.log.debug("Interrupted while waiting for the " + this.startupThread.getName() + " to complete.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.startupThread = null;
        }
        if (this.mountTracker != null) {
            this.mountTracker.close();
            this.mountTracker = null;
        }
        if (this.repository != null || this.isRepositoryServiceRegistered()) {
            this.log.info("stop: Repository still running, forcing shutdown");
            Object object = this.repoInitLock;
            synchronized (object) {
                try {
                    if (this.isRepositoryServiceRegistered()) {
                        try {
                            this.log.debug("stop: Unregistering SlingRepository service, registration=" + this.repositoryService);
                            this.unregisterService(this.repositoryService);
                        }
                        catch (Throwable t) {
                            this.log.info("stop: Uncaught problem unregistering the repository service", t);
                        }
                        this.repositoryService = null;
                    }
                    if (this.repository != null) {
                        Repository oldRepo = this.repository;
                        this.repository = null;
                        if (this.loader != null) {
                            this.loader.dispose();
                            this.loader = null;
                        }
                        this.destroy(this.masterSlingRepository);
                        try {
                            this.disposeRepository((Repository)(oldRepo instanceof ProxyRepository ? ((ProxyRepository)oldRepo).jcr : oldRepo));
                        }
                        catch (Throwable t) {
                            this.log.info("stop: Uncaught problem disposing the repository", t);
                        }
                    }
                }
                catch (Throwable t) {
                    this.log.warn("stop: Unexpected problem stopping repository", t);
                }
            }
        }
        if (this.repoInitializerTracker != null) {
            this.repoInitializerTracker.close();
            this.repoInitializerTracker = null;
        }
        if (this.whitelistTracker != null) {
            this.whitelistTracker.close();
            this.whitelistTracker = null;
        }
        this.repositoryService = null;
        this.repository = null;
        this.defaultWorkspace = null;
        this.bundleContext = null;
    }

    private static final class SlingRepositoryInitializerInfo
    implements Comparable<SlingRepositoryInitializerInfo> {
        final SlingRepositoryInitializer initializer;
        final ServiceReference<SlingRepositoryInitializer> ref;

        SlingRepositoryInitializerInfo(SlingRepositoryInitializer init, ServiceReference<SlingRepositoryInitializer> ref) {
            this.initializer = init;
            this.ref = ref;
        }

        @Override
        public int compareTo(SlingRepositoryInitializerInfo o) {
            return this.ref.compareTo(o.ref);
        }
    }

    protected static final class Config {
        protected final String defaultWorkspace;
        protected final boolean disableLoginAdministrative;

        public Config(String defaultWorkspace, boolean disableLoginAdministrative) {
            this.defaultWorkspace = defaultWorkspace;
            this.disableLoginAdministrative = disableLoginAdministrative;
        }
    }
}

