/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.api.observation.JackrabbitEventFilter;
import org.apache.jackrabbit.api.observation.JackrabbitObservationManager;
import org.apache.sling.installer.provider.jcr.impl.RescanTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RootFolderMoveListener
implements EventListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RescanTimer timer;
    private final String[] watchedPaths;
    private EventListener toCleanup;

    RootFolderMoveListener(Session session, String[] rootFolders, RescanTimer timer) throws RepositoryException {
        this.timer = timer;
        this.watchedPaths = rootFolders;
        if (this.watchedPaths != null && this.watchedPaths.length > 0) {
            JackrabbitEventFilter eventFilter = new JackrabbitEventFilter().setAdditionalPaths(this.watchedPaths).setEventTypes(32).setIsDeep(true).setNoLocal(true).setNoExternal(false);
            ObservationManager obsManager = session.getWorkspace().getObservationManager();
            if (obsManager instanceof JackrabbitObservationManager) {
                JackrabbitObservationManager observationManager = (JackrabbitObservationManager)obsManager;
                observationManager.addEventListener((EventListener)this, eventFilter);
                this.toCleanup = this;
                this.logger.info("Watching {} to detect move changes in subfolders", (Object)Arrays.toString(this.watchedPaths));
            } else {
                this.logger.warn("ObservationManager is not a JackrabbitObservationManager, won't observe moves for {}", Arrays.asList(rootFolders));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + Arrays.asList(this.watchedPaths) + ")";
    }

    void cleanup(Session session) throws RepositoryException {
        if (this.toCleanup != null) {
            session.getWorkspace().getObservationManager().removeEventListener(this.toCleanup);
        }
    }

    public void onEvent(EventIterator events) {
        this.timer.scheduleScan();
    }
}

