/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.installhook;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.installer.api.event.InstallationEvent;
import org.apache.sling.installer.api.event.InstallationListener;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OsgiInstallerListener
implements InstallationListener {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiInstallerListener.class);
    private final Set<String> initialBundleUrlsToInstall;
    private final Set<String> initialConfigUrlsToInstall;
    private final Set<String> bundleUrlsToInstall;
    private final Set<String> configUrlsToInstall;

    public OsgiInstallerListener(Set<String> bundleUrlsToInstall, Set<String> configUrlsToInstall) {
        this.initialBundleUrlsToInstall = bundleUrlsToInstall;
        this.initialConfigUrlsToInstall = configUrlsToInstall;
        this.bundleUrlsToInstall = Collections.synchronizedSet(new HashSet<String>(this.initialBundleUrlsToInstall));
        this.configUrlsToInstall = Collections.synchronizedSet(new HashSet<String>(this.initialConfigUrlsToInstall));
    }

    public void onEvent(InstallationEvent installationEvent) {
        if (installationEvent.getType() == InstallationEvent.TYPE.PROCESSED) {
            Object sourceRaw = installationEvent.getSource();
            if (!(sourceRaw instanceof TaskResource)) {
                throw new IllegalStateException("Expected source of type " + TaskResource.class.getName());
            }
            TaskResource source = (TaskResource)sourceRaw;
            String entityId = source.getEntityId();
            String url = source.getURL();
            LOG.trace("Received event about processed entityId={} url={}", (Object)entityId, (Object)url);
            if (this.bundleUrlsToInstall.contains(url)) {
                LOG.debug("Received event for bundle installed with url={}", (Object)url);
                this.bundleUrlsToInstall.remove(url);
            }
            if (this.configUrlsToInstall.contains(url)) {
                LOG.debug("Received event for config installed with url={}", (Object)url);
                this.configUrlsToInstall.remove(url);
            }
        }
    }

    public int bundlesLeftToInstall() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("initialBundleUrlsToInstall: {}", this.initialBundleUrlsToInstall);
            LOG.trace("bundleUrlsToInstall: {}", this.bundleUrlsToInstall);
        }
        return this.bundleUrlsToInstall.size();
    }

    public int configsLeftToInstall() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("initialConfigUrlsToInstall: {}", this.initialConfigUrlsToInstall);
            LOG.trace("configUrlsToInstall: {}", this.configUrlsToInstall);
        }
        return this.configUrlsToInstall.size();
    }
}

