/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.file.impl;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.sling.installer.provider.file.impl.ScanConfiguration;
import org.apache.sling.installer.provider.file.impl.ServicesListener;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    public static final String KEY_DIR = "sling.fileinstall.dir";
    public static final String KEY_DELAY = "sling.fileinstall.interval";
    public static final String KEY_WRITEBACK = "sling.fileinstall.writeback";
    private ServicesListener servicesListener;

    public void start(BundleContext context) {
        ArrayList<ScanConfiguration> configs = new ArrayList<ScanConfiguration>();
        Object dir = Activator.getProp(context, KEY_DIR);
        if (dir != null) {
            Long delay = null;
            Object interval = Activator.getProp(context, KEY_DELAY);
            if (interval != null) {
                delay = interval instanceof Number ? Long.valueOf(((Number)interval).longValue()) : Long.valueOf(interval.toString());
            }
            StringTokenizer st = new StringTokenizer(dir.toString(), ",");
            while (st.hasMoreTokens()) {
                ScanConfiguration sc = new ScanConfiguration();
                sc.directory = st.nextToken();
                sc.scanInterval = delay;
                configs.add(sc);
            }
        }
        this.servicesListener = new ServicesListener(context, configs);
    }

    public void stop(BundleContext context) {
        this.servicesListener.deactivate();
        this.servicesListener = null;
    }

    public static Object getProp(BundleContext bundleContext, String key) {
        String o = bundleContext.getProperty(key);
        if (o == null && (o = System.getProperty(key)) == null) {
            o = System.getProperty(key.toUpperCase().replace('.', '_'));
        }
        return o;
    }
}

