/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.file.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.UpdateHandler;
import org.apache.sling.installer.api.UpdateResult;
import org.apache.sling.installer.api.serializer.ConfigurationSerializer;
import org.apache.sling.installer.api.serializer.ConfigurationSerializerFactory;
import org.apache.sling.installer.provider.file.impl.FileMonitor;
import org.apache.sling.installer.provider.file.impl.Installer;
import org.apache.sling.installer.provider.file.impl.ScanConfiguration;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInstaller
implements UpdateHandler {
    private static final String CONFIG_FILE_EXTENSION = ".cfg.json";
    public static final String SCHEME_PREFIX = "fileinstall";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ScanConfiguration> scanConfigurations = new ArrayList<ScanConfiguration>();
    private final List<FileMonitor> monitors = new ArrayList<FileMonitor>();
    private final boolean writeBack;

    public FileInstaller(List<ScanConfiguration> configs, boolean writeBack) {
        this.writeBack = writeBack;
        if (configs != null) {
            this.scanConfigurations.addAll(configs);
        }
    }

    public boolean hasConfigurations() {
        return !this.scanConfigurations.isEmpty();
    }

    public void start(OsgiInstaller installer, SlingSettingsService settings) {
        for (ScanConfiguration config : this.scanConfigurations) {
            String key = config.directory;
            if (key.startsWith(settings.getSlingHomePath() + File.separator)) {
                key = "${sling.home}" + key.substring(settings.getSlingHomePath().length());
            }
            this.logger.debug("Starting monitor for {}", (Object)config.directory);
            this.monitors.add(new FileMonitor(new File(config.directory), config.scanInterval, new Installer(installer, settings, config.directory, FileInstaller.hash(key))));
        }
    }

    public void stop() {
        for (FileMonitor monitor : this.monitors) {
            monitor.stop();
        }
        this.monitors.clear();
    }

    public String[] getSchemes() {
        String[] schemes = new String[this.monitors.size()];
        int index = 0;
        for (FileMonitor m : this.monitors) {
            schemes[index] = m.getListener().getScheme();
            ++index;
        }
        return schemes;
    }

    public UpdateResult handleRemoval(String resourceType, String id, String url) {
        if (!this.writeBack) {
            return null;
        }
        int pos = url.indexOf(58);
        String path = url.substring(pos + 1);
        this.logger.debug("Removal of {}", (Object)path);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        return new UpdateResult(url);
    }

    public UpdateResult handleUpdate(String resourceType, String id, String url, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        return this.handleUpdate(resourceType, id, url, null, dict, attributes);
    }

    public UpdateResult handleUpdate(String resourceType, String id, String url, InputStream is, Map<String, Object> attributes) {
        return this.handleUpdate(resourceType, id, url, is, null, attributes);
    }

    private UpdateResult handleUpdate(String resourceType, String id, String url, InputStream is, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        if (!this.writeBack) {
            return null;
        }
        if (!resourceType.equals("config")) {
            return null;
        }
        try {
            String path;
            String prefix;
            if (url != null) {
                int pos = url.indexOf(58);
                String oldPath = url.substring(pos + 1);
                prefix = url.substring(0, pos);
                if (!oldPath.endsWith(CONFIG_FILE_EXTENSION)) {
                    int lastSlash;
                    int lastDot;
                    File file = new File(oldPath);
                    if (file.exists()) {
                        file.delete();
                    }
                    path = (lastDot = oldPath.lastIndexOf(46)) <= (lastSlash = oldPath.lastIndexOf(47)) ? oldPath + CONFIG_FILE_EXTENSION : oldPath.substring(0, lastDot) + CONFIG_FILE_EXTENSION;
                } else {
                    path = oldPath;
                }
                this.logger.debug("Update of {} at {}", (Object)resourceType, (Object)path);
            } else {
                FileMonitor first = this.monitors.get(0);
                path = first.getRoot().getAbsolutePath() + '/' + id + CONFIG_FILE_EXTENSION;
                prefix = first.getListener().getScheme();
                this.logger.debug("Add of {} at {}", (Object)resourceType, (Object)path);
            }
            File file = new File(path);
            file.getParentFile().mkdirs();
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                ((OutputStream)fos).write("# Configuration created by Apache Sling File Installer\n".getBytes(StandardCharsets.UTF_8));
                ConfigurationSerializer serializer = ConfigurationSerializerFactory.create((ConfigurationSerializerFactory.Format)ConfigurationSerializerFactory.Format.JSON);
                serializer.serialize(dict, (OutputStream)fos);
            }
            UpdateResult result = new UpdateResult(prefix + ':' + path);
            result.setResourceIsMoved(true);
            return result;
        }
        catch (IOException e) {
            this.logger.error("Unable to add/update resource " + resourceType + ':' + id, (Throwable)e);
            return null;
        }
    }

    private static String hash(String value) {
        try {
            MessageDigest d = MessageDigest.getInstance("MD5");
            d.update(value.getBytes("UTF-8"));
            BigInteger bigInt = new BigInteger(1, d.digest());
            return new String(bigInt.toString(16));
        }
        catch (Exception ignore) {
            return value;
        }
    }
}

