/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.file.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.sling.installer.provider.file.impl.FileChangesListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMonitor
extends TimerTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Timer timer = new Timer();
    private boolean stop = false;
    private boolean stopped = true;
    private final Monitorable root;
    private final FileChangesListener listener;

    public FileMonitor(File rootDir, Long interval, FileChangesListener listener) {
        this.listener = listener;
        this.root = new Monitorable(rootDir);
        FileMonitor.createStatus(this.root);
        ArrayList<File> files = new ArrayList<File>();
        this.collect(this.root.file, files);
        this.listener.initialSet(files);
        this.logger.debug("Starting file monitor for {} with an interval of {}ms", (Object)this.root.file, (Object)interval);
        this.timer.schedule((TimerTask)this, 0L, interval != null ? interval : 5000L);
    }

    public File getRoot() {
        return this.root.file;
    }

    public FileChangesListener getListener() {
        return this.listener;
    }

    private void collect(File file, List<File> files) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        this.collect(child, files);
                    }
                }
            } else {
                files.add(file);
            }
        }
    }

    private void collectDeleted(Monitorable m, List<File> files) {
        if (m.status instanceof DirStatus) {
            for (Monitorable child : ((DirStatus)m.status).children) {
                this.collectDeleted(child, files);
            }
        } else {
            files.add(m.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Timer timer = this.timer;
        synchronized (timer) {
            if (!this.stop) {
                this.stop = true;
                this.cancel();
                this.timer.cancel();
            }
            boolean interrupted = false;
            while (!this.stopped) {
                try {
                    this.timer.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        this.logger.debug("Stopped file monitor for {}", (Object)this.root.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.timer;
        synchronized (object) {
            this.stopped = false;
            if (this.stop) {
                this.stopped = true;
                this.timer.notifyAll();
                return;
            }
        }
        object = this;
        synchronized (object) {
            try {
                Collector c = new Collector();
                this.check(this.root, c);
                this.listener.updated(c.added, c.changed, c.removed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.timer;
        synchronized (object) {
            this.stopped = true;
            this.timer.notifyAll();
        }
    }

    private void check(Monitorable monitorable, Collector collector) {
        this.logger.debug("Checking {}", (Object)monitorable.file);
        if (monitorable.status instanceof NonExistingStatus) {
            if (monitorable.file.exists()) {
                FileMonitor.createStatus(monitorable);
                ArrayList<File> files = new ArrayList<File>();
                this.collect(monitorable.file, files);
                for (File file : files) {
                    collector.added.add(file);
                }
            }
        } else if (!monitorable.file.exists()) {
            ArrayList<File> files = new ArrayList<File>();
            this.collectDeleted(monitorable, files);
            for (File file : files) {
                collector.removed.add(file);
            }
            monitorable.status = NonExistingStatus.SINGLETON;
        } else {
            FileStatus fs = (FileStatus)monitorable.status;
            boolean changed = false;
            if (fs.lastModified < monitorable.file.lastModified()) {
                fs.lastModified = monitorable.file.lastModified();
                if (monitorable.file.isFile()) {
                    collector.changed.add(monitorable.file);
                }
                changed = true;
            }
            if (fs instanceof DirStatus) {
                DirStatus ds = (DirStatus)fs;
                for (int i = 0; i < ds.children.length; ++i) {
                    this.check(ds.children[i], collector);
                }
                if (changed) {
                    File[] files = monitorable.file.listFiles();
                    if (files != null) {
                        Monitorable[] children = new Monitorable[files.length];
                        for (int i = 0; i < files.length; ++i) {
                            for (int m = 0; m < ds.children.length; ++m) {
                                if (!ds.children[m].file.equals(files[i])) continue;
                                children[i] = ds.children[m];
                                break;
                            }
                            if (children[i] != null) continue;
                            children[i] = new Monitorable(files[i]);
                            children[i].status = NonExistingStatus.SINGLETON;
                            this.check(children[i], collector);
                        }
                        ds.children = children;
                    } else {
                        ds.children = new Monitorable[0];
                    }
                }
            }
        }
    }

    private static void createStatus(Monitorable monitorable) {
        monitorable.status = !monitorable.file.exists() ? NonExistingStatus.SINGLETON : (monitorable.file.isFile() ? new FileStatus(monitorable.file) : new DirStatus(monitorable.file));
    }

    private static final class NonExistingStatus {
        public static NonExistingStatus SINGLETON = new NonExistingStatus();

        private NonExistingStatus() {
        }
    }

    private static final class DirStatus
    extends FileStatus {
        public Monitorable[] children;

        public DirStatus(File dir) {
            super(dir);
            File[] files = dir.listFiles();
            if (files != null) {
                this.children = new Monitorable[files.length];
                for (int i = 0; i < files.length; ++i) {
                    this.children[i] = new Monitorable(files[i]);
                    FileMonitor.createStatus(this.children[i]);
                }
            } else {
                this.children = new Monitorable[0];
            }
        }
    }

    private static class FileStatus {
        public long lastModified;

        public FileStatus(File file) {
            this.lastModified = file.lastModified();
        }
    }

    private static final class Monitorable {
        public final File file;
        public Object status;

        public Monitorable(File file) {
            this.file = file;
        }
    }

    private static final class Collector {
        public final List<File> added = new ArrayList<File>();
        public final List<File> removed = new ArrayList<File>();
        public final List<File> changed = new ArrayList<File>();

        private Collector() {
        }
    }
}

