/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factory.model.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.extension.apiregions.launcher.LauncherProperties;
import org.apache.sling.feature.io.archive.ArchiveReader;
import org.apache.sling.feature.io.artifacts.ArtifactHandler;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.factory.model.impl.AbstractFeatureModelTask;
import org.apache.sling.installer.factory.model.impl.InstallContext;
import org.osgi.framework.BundleContext;

public class InstallFeatureModelTask
extends AbstractFeatureModelTask {
    private static final String PROP_idbsnver = "mapping.bundleid.bsnver";
    private static final String PROP_bundleFeatures = "mapping.bundleid.features";
    private static final String PROP_featureRegions = "mapping.featureid.regions";
    private static final String PROP_regionPackage = "mapping.region.packages";
    private static final String REGION_FACTORY_PID = "org.apache.sling.feature.apiregions.factory~";
    private static final String REPOINIT_FACTORY_PID = "org.apache.sling.jcr.repoinit.RepositoryInitializer~";
    private final InstallContext installContext;

    public InstallFeatureModelTask(TaskResourceGroup group, InstallContext installContext, BundleContext bundleContext) {
        super(group, bundleContext);
        this.installContext = installContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(InstallationContext ctx) {
        try {
            TaskResource resource = this.getResource();
            ctx.log("Installing {}", new Object[]{resource.getEntityId()});
            String featureJson = (String)resource.getAttribute("feature");
            if (featureJson == null) {
                ctx.log("Unable to install feature model resource {} : no model found", new Object[]{resource});
                this.getResourceGroup().setFinishState(ResourceState.IGNORED, null, "No model found");
            } else {
                boolean success = false;
                List<InstallableResource> result = this.transform(featureJson, resource);
                if (result == null) {
                    ctx.log("Unable to install feature model resource {} : unable to create resources", new Object[]{resource});
                    this.getResourceGroup().setFinishState(ResourceState.IGNORED, null, "Unable to create resources");
                } else {
                    if (!result.isEmpty()) {
                        OsgiInstaller installer = this.getService(OsgiInstaller.class);
                        if (installer != null) {
                            installer.registerResources(this.getScheme(resource), result.toArray(new InstallableResource[result.size()]));
                        } else {
                            ctx.log("Unable to install feature model resource {} : unable to get OSGi installer", new Object[]{resource});
                            this.getResourceGroup().setFinishState(ResourceState.IGNORED, null, "Unable to get OSGi installer");
                            return;
                        }
                    }
                    this.getResourceGroup().setFinishState(ResourceState.INSTALLED);
                    success = true;
                }
                if (success) {
                    ctx.log("Installed {}", new Object[]{resource.getEntityId()});
                }
            }
        }
        finally {
            this.cleanup();
        }
    }

    private File getArtifactFile(File baseDir, ArtifactId id) {
        return new File(baseDir, id.toMvnPath().replace('/', File.separatorChar));
    }

    private List<InstallableResource> transform(String featureJson, TaskResource rsrc) {
        Extension regionExt;
        Feature feature = null;
        try {
            StringReader reader = new StringReader(featureJson);
            Object object = null;
            try {
                feature = FeatureJSONReader.read((Reader)reader, null);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            this.logger.warn("Unable to read feature model file", (Throwable)ioe);
        }
        if (feature == null) {
            return null;
        }
        ArrayList<InstallableResource> result = new ArrayList<InstallableResource>();
        for (Configuration cfg : feature.getConfigurations()) {
            result.add(new InstallableResource("/".concat(cfg.getPid()).concat(".config"), null, cfg.getConfigurationProperties(), null, "config", null));
        }
        Extension repoInit = feature.getExtensions().getByName("repoinit");
        if (repoInit != null && repoInit.getType() == ExtensionType.TEXT) {
            String configPid = REPOINIT_FACTORY_PID.concat(feature.getId().toMvnName().replace('-', '_'));
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("scripts", repoInit.getText());
            ((Dictionary)props).put("service.ranking", 200);
            result.add(new InstallableResource("/".concat(configPid).concat(".config"), null, props, null, "config", null));
        }
        if (this.installContext.storageDirectory != null) {
            final byte[] buffer = new byte[0x10000000];
            try {
                InputStream is = rsrc.getInputStream();
                Object object = null;
                try {
                    ArchiveReader.read((InputStream)is, (ArchiveReader.ArtifactConsumer)new ArchiveReader.ArtifactConsumer(){

                        public void consume(ArtifactId id, InputStream is) throws IOException {
                            File artifactFile = InstallFeatureModelTask.this.getArtifactFile(((InstallFeatureModelTask)InstallFeatureModelTask.this).installContext.storageDirectory, id);
                            if (!artifactFile.exists()) {
                                artifactFile.getParentFile().mkdirs();
                                try (FileOutputStream os = new FileOutputStream(artifactFile);){
                                    int l = 0;
                                    while ((l = is.read(buffer)) > 0) {
                                        ((OutputStream)os).write(buffer, 0, l);
                                    }
                                }
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                this.logger.warn("Unable to extract artifacts from feature model " + feature.getId().toMvnId(), (Throwable)ioe);
                return null;
            }
        }
        if ((regionExt = feature.getExtensions().getByName("api-regions")) != null) {
            try {
                ApiRegions regions = ApiRegions.parse(regionExt.getJSONStructure().asJsonArray());
                String configPid = REGION_FACTORY_PID.concat(feature.getId().toMvnName().replace('-', '_'));
                Hashtable<String, String[]> props = new Hashtable<String, String[]>();
                ((Dictionary)props).put(PROP_idbsnver, this.convert(LauncherProperties.getBundleIDtoBSNandVersionMap(feature, (ArtifactProvider)this.installContext.artifactManager)));
                ((Dictionary)props).put(PROP_bundleFeatures, this.convert(LauncherProperties.getBundleIDtoFeaturesMap(feature)));
                ((Dictionary)props).put(PROP_featureRegions, this.convert(LauncherProperties.getFeatureIDtoRegionsMap(regions)));
                ((Dictionary)props).put(PROP_regionPackage, this.convert(LauncherProperties.getRegionNametoPackagesMap(regions)));
                result.add(new InstallableResource("/".concat(configPid).concat(".config"), null, props, null, "config", null));
            }
            catch (IOException ioe) {
                this.logger.warn("Unable to parse region information " + feature.getId().toMvnId(), (Throwable)ioe);
                return null;
            }
        }
        for (Artifact bundle : feature.getBundles()) {
            if (this.addArtifact(bundle, result)) continue;
            return null;
        }
        Extension ext = feature.getExtensions().getByName("content-packages");
        if (ext != null && ext.getType() == ExtensionType.ARTIFACTS) {
            for (Artifact artifact : ext.getArtifacts()) {
                this.addArtifact(artifact, result);
            }
        }
        return result;
    }

    private String[] convert(Properties props) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            result.add(entry.getKey().toString().concat("=").concat(entry.getValue().toString()));
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean addArtifact(Artifact artifact, List<InstallableResource> result) {
        ArtifactHandler handler;
        File artifactFile;
        File file = artifactFile = this.installContext.storageDirectory == null ? null : this.getArtifactFile(this.installContext.storageDirectory, artifact.getId());
        if (artifactFile == null || !artifactFile.exists()) {
            try {
                handler = this.installContext.artifactManager.getArtifactHandler(artifact.getId().toMvnUrl());
            }
            catch (IOException ignore) {
                return false;
            }
        }
        try {
            handler = new ArtifactHandler(artifactFile);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (handler == null) {
            return false;
        }
        try {
            URLConnection connection = handler.getLocalURL().openConnection();
            connection.connect();
            InputStream is = connection.getInputStream();
            long lastModified = connection.getLastModified();
            String digest = lastModified == 0L ? null : String.valueOf(lastModified);
            Hashtable<String, Object> dict = new Hashtable<String, Object>();
            if (artifact.getStartOrder() > 0) {
                ((Dictionary)dict).put("bundle.startlevel", artifact.getStartOrder());
            }
            ((Dictionary)dict).put("resource.uri.hint", handler.getLocalURL().toString());
            result.add(new InstallableResource("/".concat(artifact.getId().toMvnName()), is, dict, digest, "file", null));
        }
        catch (IOException ioe) {
            this.logger.warn("Unable to read artifact " + handler.getLocalURL(), (Throwable)ioe);
            return false;
        }
        return true;
    }

    public String getSortKey() {
        return "30-" + this.getResource().getAttribute("featureId");
    }
}

