/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.util.Arrays;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.osgi.util.converter.Converters;

public class MetatypeHandler {
    private final MetaTypeService srv;
    private final BundleContext bundleContext;

    public MetatypeHandler(MetaTypeService mts, BundleContext bundleContext) {
        this.srv = mts;
        this.bundleContext = bundleContext;
    }

    public void updateConfiguration(String factoryPid, String pid, Dictionary<String, Object> props, Dictionary<String, Object> defaultProps) {
        ObjectClassDefinition ocd = factoryPid != null ? this.getObjectClassDefinition(factoryPid) : this.getObjectClassDefinition(pid);
        if (ocd != null) {
            for (AttributeDefinition ad : ocd.getAttributeDefinitions(-1)) {
                String propName = ad.getID();
                Object newValue = props.get(propName);
                if (newValue == null || defaultProps != null && defaultProps.get(propName) != null) continue;
                if (ad.getCardinality() == 0) {
                    if (this.shouldSet(ad, newValue.toString())) continue;
                    props.remove(propName);
                    continue;
                }
                String[] array = (String[])Converters.standardConverter().convert(newValue).to(String[].class);
                if (this.shouldSet(ad, array)) continue;
                props.remove(propName);
            }
        }
    }

    private ObjectClassDefinition getObjectClassDefinition(String pid) {
        for (Bundle b : this.bundleContext.getBundles()) {
            try {
                ObjectClassDefinition ocd;
                MetaTypeInformation mti = this.srv.getMetaTypeInformation(b);
                if (mti == null || (ocd = mti.getObjectClassDefinition(pid, null)) == null) continue;
                return ocd;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    boolean shouldSet(AttributeDefinition ad, String value) {
        if (value.isEmpty() && ad.getDefaultValue() == null) {
            return false;
        }
        return ad.getDefaultValue() == null || !value.equals(ad.getDefaultValue()[0]);
    }

    boolean shouldSet(AttributeDefinition ad, String[] values) {
        if (ad.getDefaultValue() == null && (values.length == 0 || values.length == 1 && values[0].isEmpty())) {
            return false;
        }
        return ad.getDefaultValue() == null || !Arrays.equals(ad.getDefaultValue(), values);
    }
}

