/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.stream.Collectors;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.serializer.ConfigurationSerializerFactory;
import org.apache.sling.installer.factories.configuration.impl.Activator;
import org.apache.sling.installer.factories.configuration.impl.ConfigTaskCreator;
import org.apache.sling.installer.factories.configuration.impl.ConfigUtil;
import org.apache.sling.installer.factories.configuration.impl.MetatypeHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.metatype.MetaTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling OSGi Installer Configuration Serializer Web Console Plugin", "felix.webconsole.label=osgi-installer-config-printer", "felix.webconsole.title=OSGi Installer Configuration Printer", "felix.webconsole.category=OSGi"})
public class ConfigurationSerializerWebConsolePlugin
extends GenericServlet {
    public static final String LABEL = "osgi-installer-config-printer";
    private static final String RES_LOC = "osgi-installer-config-printer/res/ui/";
    private static final String PARAMETER_PID = "pid";
    private static final String PARAMETER_FORMAT = "format";
    private static final String PARAMETER_REMOVE_COMPONENT_DEFAULT_PROPERTIES = "removeComponentDefaultProps";
    private static final String PARAMETER_REMOVE_METATYPE_DEFAULT_PROPERTIES = "removeMetatypeDefaultProps";
    private static final String PARAMETER_REMOVE_MERGED_DEFAULT_PROPERTIES = "removeMergedDefaultProps";
    private final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSerializerWebConsolePlugin.class);
    @Reference
    ConfigurationAdmin configurationAdmin;
    @Reference
    MetaTypeService metatypeService;
    @Reference
    private InfoProvider infoProvider;
    @Reference
    private ServiceComponentRuntime scr;
    private final BundleContext bundleContext;

    @Activate
    public ConfigurationSerializerWebConsolePlugin(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException {
        boolean removeMergedDefaultProperties;
        boolean removeComponentDefaultProperties;
        boolean removeMetatypeDefaultProperties;
        String pid = request.getParameter(PARAMETER_PID);
        String format = request.getParameter(PARAMETER_FORMAT);
        if (format == null) {
            removeMetatypeDefaultProperties = true;
            removeComponentDefaultProperties = true;
            removeMergedDefaultProperties = true;
        } else {
            removeMetatypeDefaultProperties = Boolean.parseBoolean(request.getParameter(PARAMETER_REMOVE_METATYPE_DEFAULT_PROPERTIES));
            removeComponentDefaultProperties = Boolean.parseBoolean(request.getParameter(PARAMETER_REMOVE_COMPONENT_DEFAULT_PROPERTIES));
            removeMergedDefaultProperties = Boolean.parseBoolean(request.getParameter(PARAMETER_REMOVE_MERGED_DEFAULT_PROPERTIES));
        }
        Collection<Object> allComponentDescriptions = removeComponentDefaultProperties ? this.scr.getComponentDescriptionDTOs(new Bundle[0]) : Collections.emptyList();
        MetatypeHandler metatypeHandler = new MetatypeHandler(this.metatypeService, this.bundleContext);
        ConfigurationSerializerFactory.Format serializationFormat = ConfigurationSerializerFactory.Format.JSON;
        if (format != null && !format.trim().isEmpty()) {
            try {
                serializationFormat = ConfigurationSerializerFactory.Format.valueOf((String)format);
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.warn("Illegal parameter 'format' given, falling back to default '{}'", (Object)serializationFormat, (Object)e);
            }
        }
        PrintWriter pw = response.getWriter();
        pw.println("<script type=\"text/javascript\" src=\"osgi-installer-config-printer/res/ui/clipboard.js\"></script>");
        pw.print("<form method='get'>");
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        this.titleHtml(pw, "OSGi Installer Configuration Printer", "To emit the configuration properties just enter the configuration PID, select a <a href='https://sling.apache.org/documentation/bundles/configuration-installer-factory.html'>serialization format</a> and click 'Print'");
        this.tr(pw);
        this.tdLabel(pw, "PID");
        this.tdContent(pw);
        pw.print("<input type='text' name='");
        pw.print(PARAMETER_PID);
        pw.print("' value='");
        if (pid != null) {
            pw.print(this.escapeXml(pid));
        }
        pw.println("' class='input' size='120' minlength='3'>");
        this.closeTd(pw);
        this.closeTr(pw);
        this.tr(pw);
        this.tdLabel(pw, "Remove Properties");
        this.tdContent(pw);
        pw.print("<input type='checkbox' name='");
        pw.print(PARAMETER_REMOVE_METATYPE_DEFAULT_PROPERTIES);
        pw.print("'");
        if (removeMetatypeDefaultProperties) {
            pw.print(" checked");
        }
        pw.println(" id='");
        pw.print(PARAMETER_REMOVE_METATYPE_DEFAULT_PROPERTIES);
        pw.println("' class='input' value='true'>");
        pw.println("<label for='");
        pw.println(PARAMETER_REMOVE_METATYPE_DEFAULT_PROPERTIES);
        pw.println("'>Metatype Default Properties</label>");
        pw.print("<input type='checkbox' name='");
        pw.print(PARAMETER_REMOVE_COMPONENT_DEFAULT_PROPERTIES);
        pw.print("'");
        if (removeComponentDefaultProperties) {
            pw.print(" checked");
        }
        pw.println(" id='");
        pw.print(PARAMETER_REMOVE_COMPONENT_DEFAULT_PROPERTIES);
        pw.println("' class='input' value='true'>");
        pw.println("<label for='");
        pw.println(PARAMETER_REMOVE_COMPONENT_DEFAULT_PROPERTIES);
        pw.println("'>Declarative Services Component Properties</label>");
        if (Activator.MERGE_SCHEMES != null) {
            pw.print("<input type='checkbox' name='");
            pw.print(PARAMETER_REMOVE_MERGED_DEFAULT_PROPERTIES);
            pw.print("'");
            if (removeMergedDefaultProperties) {
                pw.print(" checked");
            }
            pw.println(" id='");
            pw.print(PARAMETER_REMOVE_MERGED_DEFAULT_PROPERTIES);
            pw.println("' class='input' value='true'>");
            pw.println("<label for='");
            pw.println(PARAMETER_REMOVE_MERGED_DEFAULT_PROPERTIES);
            pw.println("'>Merged Properties</label>");
        }
        pw.println("<p>Selecting any of these options strips those properties which have the same name and value as one from any of the selected sources. The removed properties are very likely being redundant and therefore do not need to be added to serialized configs.</a>");
        this.closeTd(pw);
        this.closeTr(pw);
        this.tr(pw);
        this.tdLabel(pw, "Serialization Format");
        this.tdContent(pw);
        pw.print("<select name='");
        pw.print(PARAMETER_FORMAT);
        pw.println("'>");
        this.option(pw, "JSON", "OSGi Configurator JSON", format);
        this.option(pw, "CONFIG", "Apache Felix Config", format);
        this.option(pw, "PROPERTIES", "Java Properties", format);
        this.option(pw, "PROPERTIES_XML", "Java Properties (XML)", format);
        pw.println("</select>");
        pw.println("&nbsp;&nbsp;<input type='submit' value='Print' class='submit'>");
        this.closeTd(pw);
        this.closeTr(pw);
        if (pid != null && !pid.trim().isEmpty()) {
            Dictionary<String, Object> properties;
            this.tr(pw);
            this.tdLabel(pw, "Serialized Configuration Properties");
            this.tdContent(pw);
            Configuration configuration = this.configurationAdmin.getConfiguration(pid, null);
            Dictionary<String, Object> mergedProperties = ConfigTaskCreator.getDefaultProperties(this.infoProvider, pid);
            if (mergedProperties == null) {
                mergedProperties = new Hashtable<String, Object>();
            }
            if ((properties = configuration.getProperties()) == null) {
                pw.print("<p class='ui-state-error-text'>");
                pw.print("No configuration properties for pid '" + this.escapeXml(pid) + "' found!");
                pw.println("</p>");
            } else {
                properties = ConfigUtil.cleanConfiguration(properties);
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    if (removeMetatypeDefaultProperties) {
                        metatypeHandler.updateConfiguration(configuration.getFactoryPid(), configuration.getPid(), properties, mergedProperties);
                    }
                    if (removeComponentDefaultProperties) {
                        this.removeComponentDefaultProperties(allComponentDescriptions, configuration.getPid(), configuration.getFactoryPid(), properties, mergedProperties);
                    }
                    if (removeMergedDefaultProperties) {
                        ConfigUtil.removeRedundantProperties(properties, mergedProperties);
                    }
                    ConfigurationSerializerFactory.create((ConfigurationSerializerFactory.Format)serializationFormat).serialize(properties, (OutputStream)baos);
                    pw.println("<textarea rows=\"20\" cols=\"120\" id=\"output\" readonly>");
                    pw.print(new String(baos.toByteArray(), StandardCharsets.UTF_8));
                    pw.println("</textarea>");
                    pw.println("<button type='button' id='copy'>Copy to Clipboard</a>");
                }
                catch (Exception e) {
                    pw.print("<p class='ui-state-error-text'>");
                    pw.print("Error serializing pid '" + this.escapeXml(pid) + "': " + e.getMessage());
                    pw.println("</p>");
                    this.LOGGER.warn("Error serializing pid '{}'", (Object)pid, (Object)e);
                }
            }
            this.closeTd(pw);
            this.closeTr(pw);
        }
        pw.println("</table>");
        pw.print("</form>");
    }

    private void tdContent(PrintWriter pw) {
        pw.print("<td class='content' colspan='2'>");
    }

    private void closeTd(PrintWriter pw) {
        pw.print("</td>");
    }

    private void closeTr(PrintWriter pw) {
        pw.println("</tr>");
    }

    private void tdLabel(PrintWriter pw, String label) {
        pw.print("<td class='content'>");
        pw.print(label);
        pw.println("</td>");
    }

    private void tr(PrintWriter pw) {
        pw.println("<tr class='content'>");
    }

    private void option(PrintWriter pw, String value, String label, String selectedValue) {
        pw.print("<option value='");
        pw.print(value);
        pw.print("'");
        if (value.equals(selectedValue)) {
            pw.print(" selected");
        }
        pw.print(">");
        pw.print(label);
        pw.println("</option>");
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        this.tr(pw);
        pw.print("<th colspan='3' class='content container'>");
        pw.print(this.escapeXml(title));
        pw.println("</th>");
        this.closeTr(pw);
        if (description != null) {
            this.tr(pw);
            pw.print("<td colspan='3' class='content'>");
            pw.print(description);
            pw.println("</th>");
            this.closeTr(pw);
        }
    }

    protected String escapeXml(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\"') {
                b.append("&quot;");
                continue;
            }
            if (c == '\'') {
                b.append("&apos;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private void removeComponentDefaultProperties(Collection<ComponentDescriptionDTO> componentDescriptions, String pid, String factoryPid, Dictionary<String, Object> dict, Dictionary<String, Object> mergedProperties) {
        String effectivePid = factoryPid != null ? factoryPid : pid;
        Collection relevantComponentDescriptions = componentDescriptions.stream().filter(c -> Arrays.asList(c.configurationPid).contains(effectivePid)).collect(Collectors.toList());
        Enumeration<String> e = dict.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object newValue = dict.get(key);
            if (!relevantComponentDescriptions.stream().allMatch(c -> ConfigUtil.isSameValue(newValue, c.properties.get(key)) && mergedProperties.get(key) == null)) continue;
            dict.remove(key);
        }
    }

    String getRelativeResourcePrefix() {
        return RES_LOC;
    }

    private URL getResource(String path) {
        if (path.startsWith("/" + this.getRelativeResourcePrefix())) {
            int index = path.indexOf(47, 1);
            if (index <= 0) {
                throw new IllegalStateException("The relativeResourcePrefix must contain at least one '/'");
            }
            return ((Object)((Object)this)).getClass().getResource(path.substring(index));
        }
        return null;
    }
}

