/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.felix.webconsole.spi.ConfigurationHandler;
import org.apache.felix.webconsole.spi.ValidationException;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.factories.configuration.impl.ConfigTaskCreator;
import org.apache.sling.installer.factories.configuration.impl.MetatypeHandler;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class WebconsoleConfigurationHandler
implements ConfigurationHandler {
    static final String META_TYPE_NAME = "org.osgi.service.metatype.MetaTypeService";
    private final InfoProvider infoProvider;
    private final ServiceTracker<Object, Object> metatypeTracker;
    private final BundleContext bundleContext;

    public WebconsoleConfigurationHandler(BundleContext context, InfoProvider infoProvider) {
        this.infoProvider = infoProvider;
        this.bundleContext = context;
        this.metatypeTracker = new ServiceTracker(context, META_TYPE_NAME, null);
        this.metatypeTracker.open();
    }

    public void deactivate() {
        this.metatypeTracker.close();
    }

    public void createConfiguration(String pid) throws ValidationException, IOException {
    }

    public void createFactoryConfiguration(String factoryPid, String name) throws ValidationException, IOException {
    }

    public void deleteConfiguration(String factoryPid, String pid) throws ValidationException, IOException {
    }

    public void updateConfiguration(String factoryPid, String pid, Dictionary<String, Object> props) throws ValidationException, IOException {
        Object mts = this.metatypeTracker.getService();
        if (mts != null) {
            Dictionary<String, Object> defaultProps = ConfigTaskCreator.getDefaultProperties(this.infoProvider, pid);
            MetatypeHandler mt = new MetatypeHandler(mts, this.bundleContext);
            mt.updateConfiguration(factoryPid, pid, props, defaultProps);
        }
    }
}

