/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.installer.api.ResourceChangeListener;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.factories.configuration.impl.ConfigTaskCreator;
import org.apache.sling.installer.factories.configuration.impl.ConfigUpdateHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ServicesListener {
    public static final String VENDOR = "The Apache Software Foundation";
    private final BundleContext bundleContext;
    private final Listener changeHandlerListener;
    private final Listener configAdminListener;
    private final Listener infoServiceListener;
    private volatile ServiceRegistration<?> configTaskCreatorRegistration;
    private volatile ConfigTaskCreator configTaskCreator;
    private final AtomicBoolean active = new AtomicBoolean(false);

    public ServicesListener(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.changeHandlerListener = new Listener(ResourceChangeListener.class.getName());
        this.configAdminListener = new Listener(ConfigurationAdmin.class.getName());
        this.infoServiceListener = new Listener(InfoProvider.class.getName());
        this.infoServiceListener.start();
        this.changeHandlerListener.start();
        this.configAdminListener.start();
    }

    public synchronized void notifyChange() {
        ResourceChangeListener listener = (ResourceChangeListener)this.changeHandlerListener.getService();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminListener.getService();
        InfoProvider infoProvider = (InfoProvider)this.infoServiceListener.getService();
        if (configAdmin != null && listener != null && infoProvider != null) {
            if (this.configTaskCreator == null) {
                this.active.set(true);
                this.configTaskCreator = new ConfigTaskCreator(listener, configAdmin, infoProvider);
                ConfigUpdateHandler handler = new ConfigUpdateHandler(configAdmin, this);
                this.configTaskCreatorRegistration = handler.register(this.bundleContext);
            }
        } else {
            this.stop();
        }
    }

    private synchronized void stop() {
        this.active.set(false);
        if (this.configTaskCreatorRegistration != null) {
            this.configTaskCreatorRegistration.unregister();
            this.configTaskCreatorRegistration = null;
        }
        this.configTaskCreator = null;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public synchronized void finishedUpdating() {
        if (this.isActive()) {
            this.configTaskCreatorRegistration.unregister();
            this.configTaskCreatorRegistration = this.configTaskCreator.register(this.bundleContext);
        }
    }

    public void deactivate() {
        this.infoServiceListener.deactivate();
        this.changeHandlerListener.deactivate();
        this.configAdminListener.deactivate();
        this.stop();
    }

    protected final class Listener
    implements ServiceListener {
        private final String serviceName;
        private ServiceReference<?> reference;
        private Object service;

        public Listener(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() {
            this.retainService();
            try {
                ServicesListener.this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + this.serviceName + ")");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occured.", ise);
            }
        }

        public void deactivate() {
            ServicesListener.this.bundleContext.removeServiceListener((ServiceListener)this);
        }

        public synchronized Object getService() {
            return this.service;
        }

        private synchronized void retainService() {
            if (this.reference == null) {
                this.reference = ServicesListener.this.bundleContext.getServiceReference(this.serviceName);
                if (this.reference != null) {
                    this.service = ServicesListener.this.bundleContext.getService(this.reference);
                    if (this.service == null) {
                        this.reference = null;
                    } else {
                        ServicesListener.this.notifyChange();
                    }
                }
            }
        }

        private synchronized void releaseService() {
            if (this.reference != null) {
                this.service = null;
                ServicesListener.this.bundleContext.ungetService(this.reference);
                this.reference = null;
                ServicesListener.this.notifyChange();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.retainService();
            } else if (event.getType() == 4) {
                this.releaseService();
            }
        }
    }
}

