/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.installer.api.tasks.ResourceUpdater;
import org.apache.sling.installer.api.tasks.UpdatableResourceGroup;
import org.apache.sling.installer.factories.configuration.impl.ConfigUtil;
import org.apache.sling.installer.factories.configuration.impl.ServicesListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUpdateHandler
implements ResourceUpdater {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationAdmin configAdmin;
    private final ServicesListener activator;

    public ConfigUpdateHandler(ConfigurationAdmin configAdmin, ServicesListener activator) {
        this.configAdmin = configAdmin;
        this.activator = activator;
    }

    public ServiceRegistration<?> register(BundleContext bundleContext) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.description", "Apache Sling Configuration Install Task Factory Update Handler");
        props.put("service.vendor", "The Apache Software Foundation");
        String[] serviceInterfaces = new String[]{ResourceUpdater.class.getName()};
        return bundleContext.registerService(serviceInterfaces, (Object)this, props);
    }

    public void update(Collection<UpdatableResourceGroup> groups) {
        for (UpdatableResourceGroup group : groups) {
            this.update(group);
        }
        this.activator.finishedUpdating();
    }

    private void update(UpdatableResourceGroup group) {
        if (this.activator.isActive() && "config".equals(group.getResourceType())) {
            if (group.getAlias() == null && group.getId().contains("~") && group.getId().contains("-")) {
                this.cleanupDuplicateFactoryConfig(group);
            } else if (group.getAlias() != null || group.getId().contains("-")) {
                this.logger.debug("Configuration going under updation is : {} with alias : {}", (Object)group.getId(), (Object)group.getAlias());
                this.updateFactoryConfig(group);
            }
        }
    }

    protected String[] getFactoryPidAndPid(String alias, String oldId) {
        String pid;
        String factoryPid;
        if (alias != null) {
            if (alias.startsWith(oldId)) {
                int lastDotIndex = oldId.length();
                String factoryIdString = alias.substring(0, lastDotIndex + 1);
                factoryPid = alias.substring(0, this.getMiddleDotSplitIndex(factoryIdString));
                pid = alias.substring(lastDotIndex + 1);
            } else {
                int pos = 0;
                while (alias.charAt(pos) == oldId.charAt(pos)) {
                    ++pos;
                }
                while (alias.charAt(pos - 1) != '.') {
                    --pos;
                }
                factoryPid = alias.substring(0, pos - 1);
                pid = oldId.substring(factoryPid.length() + 1);
            }
        } else {
            int lastDotIndex = oldId.lastIndexOf(46);
            String factoryIdString = oldId.substring(0, lastDotIndex + 1);
            factoryPid = oldId.substring(0, this.getMiddleDotSplitIndex(factoryIdString));
            pid = oldId.substring(lastDotIndex + 1);
        }
        return new String[]{factoryPid, pid};
    }

    private int getMiddleDotSplitIndex(String strId) {
        int dotCount = 0;
        int[] dotIndexArray = new int[strId.length()];
        for (int i = 0; i < strId.length(); ++i) {
            if (strId.charAt(i) != '.') continue;
            dotIndexArray[++dotCount] = i;
        }
        return dotIndexArray[dotCount / 2];
    }

    private void updateFactoryConfig(UpdatableResourceGroup group) {
        String alias = group.getAlias();
        String oldId = group.getId();
        String[] result = this.getFactoryPidAndPid(alias, oldId);
        String factoryPid = result[0];
        String pid = result[1];
        String newId = ConfigUtil.getPIDOfFactoryPID(factoryPid, pid);
        group.setId(newId);
        group.setAlias(null);
        this.logger.debug("Updating factory configuration from {} to {}", (Object)oldId, (Object)newId);
        try {
            Configuration cfg = ConfigUtil.getLegacyFactoryConfig(this.configAdmin, factoryPid, alias, pid);
            if (cfg != null) {
                String location = cfg.getBundleLocation();
                Dictionary<String, Object> dict = ConfigUtil.cleanConfiguration(cfg.getProperties());
                cfg.delete();
                Configuration upCfg = this.configAdmin.getFactoryConfiguration(factoryPid, pid, location);
                upCfg.update(dict);
            }
        }
        catch (IOException | InvalidSyntaxException throwable) {
            // empty catch block
        }
        group.update();
    }

    private void cleanupDuplicateFactoryConfig(UpdatableResourceGroup group) {
        String newPid = group.getId();
        int indexOfSeparator = newPid.lastIndexOf(126);
        String pid = newPid.substring(indexOfSeparator + 1);
        String factoryPid = newPid.substring(0, indexOfSeparator);
        try {
            Configuration cfg = ConfigUtil.getLegacyFactoryConfig(this.configAdmin, factoryPid, null, pid);
            if (cfg != null) {
                this.logger.debug("Duplicate configuration being cleaned up is : {}", (Object)(cfg.getFactoryPid() + '.' + cfg.getPid()));
                cfg.delete();
            }
        }
        catch (IOException | InvalidSyntaxException throwable) {
            // empty catch block
        }
    }
}

