/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.factories.configuration.impl.AbstractConfigTask;
import org.apache.sling.installer.factories.configuration.impl.ConfigUtil;
import org.apache.sling.installer.factories.configuration.impl.Coordinator;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigRemoveTask
extends AbstractConfigTask {
    private static final String CONFIG_REMOVE_ORDER = "10-";

    public ConfigRemoveTask(TaskResourceGroup r, ConfigurationAdmin configAdmin) {
        super(r, configAdmin);
    }

    public String getSortKey() {
        return CONFIG_REMOVE_ORDER + this.getRealPID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(InstallationContext ctx) {
        Coordinator coordinator = Coordinator.SHARED;
        synchronized (coordinator) {
            try {
                Configuration cfg = ConfigUtil.getConfiguration(this.getConfigurationAdmin(), this.factoryPid, this.configPid);
                if (cfg == null) {
                    this.getLogger().debug("Cannot delete config , pid={} not found, ignored ({})", (Object)this.getRealPID(), (Object)this.getResource());
                } else if (!ConfigUtil.isSameData(cfg.getProperties(), this.getResource().getDictionary())) {
                    this.getLogger().debug("Configuration has changed after it has been installed!");
                } else {
                    Coordinator.Operation op = new Coordinator.Operation(cfg.getPid(), cfg.getFactoryPid(), true);
                    this.getLogger().debug("Deleting config {} ({})", (Object)this.getRealPID(), (Object)this.getResource());
                    cfg.delete();
                    ctx.log("Deleted configuration {} from resource {}", new Object[]{this.getRealPID(), this.getResource()});
                    Coordinator.SHARED.add(op);
                }
            }
            catch (Exception e) {
                this.getLogger().debug("Exception during removal of config " + this.getResource() + " : " + e.getMessage() + ". Retrying later.", (Throwable)e);
            }
            this.setFinishedState(ResourceState.UNINSTALLED);
        }
    }
}

