/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.sling.installer.api.ResourceChangeListener;
import org.apache.sling.installer.api.tasks.ChangeStateTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.apache.sling.installer.factories.configuration.impl.ConfigInstallTask;
import org.apache.sling.installer.factories.configuration.impl.ConfigRemoveTask;
import org.apache.sling.installer.factories.configuration.impl.ConfigUtil;
import org.apache.sling.installer.factories.configuration.impl.Coordinator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTaskCreator
implements InstallTaskFactory,
ConfigurationListener,
ResourceTransformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationAdmin configAdmin;
    private final ResourceChangeListener changeListener;
    private static final List<String> EXTENSIONS = Arrays.asList(".config", ".properties", ".cfg", ".cfg.json");

    public ConfigTaskCreator(ResourceChangeListener listener, ConfigurationAdmin configAdmin) {
        this.changeListener = listener;
        this.configAdmin = configAdmin;
    }

    public ServiceRegistration<?> register(BundleContext bundleContext) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.description", "Apache Sling Configuration Install Task Factory");
        props.put("service.vendor", "The Apache Software Foundation");
        props.put("installtaskfactory.name", "org.osgi.service.cm");
        props.put("resourcetransformer.name", "org.osgi.service.cm");
        String[] serviceInterfaces = new String[]{InstallTaskFactory.class.getName(), ConfigurationListener.class.getName(), ResourceTransformer.class.getName()};
        return bundleContext.registerService(serviceInterfaces, (Object)this, props);
    }

    public InstallTask createTask(TaskResourceGroup group) {
        TaskResource second;
        TaskResource toActivate = group.getActiveResource();
        if (!toActivate.getType().equals("config")) {
            return null;
        }
        Object result = toActivate.getState() == ResourceState.UNINSTALL ? (!((second = group.getNextActiveResource()) == null || second.getState() != ResourceState.IGNORED && second.getState() != ResourceState.INSTALLED && second.getState() != ResourceState.INSTALL || second.getDictionary() != null && second.getDictionary().get("org.apache.sling.installer.api.template") != null) ? new ChangeStateTask(group, ResourceState.UNINSTALLED) : new ConfigRemoveTask(group, this.configAdmin)) : new ConfigInstallTask(group, this.configAdmin);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationEvent(ConfigurationEvent event) {
        Coordinator coordinator = Coordinator.SHARED;
        synchronized (coordinator) {
            if (event.getType() == 2) {
                Coordinator.Operation op = Coordinator.SHARED.get(event.getPid(), event.getFactoryPid(), true);
                if (op == null) {
                    this.changeListener.resourceRemoved("config", event.getPid());
                } else {
                    this.logger.debug("Ignoring configuration event for {}:{}", (Object)event.getPid(), (Object)event.getFactoryPid());
                }
            } else if (event.getType() == 1) {
                try {
                    Configuration config = ConfigUtil.getConfiguration(this.configAdmin, null, event.getPid());
                    Coordinator.Operation op = Coordinator.SHARED.get(event.getPid(), event.getFactoryPid(), false);
                    if (config != null && op == null) {
                        boolean persist = ConfigUtil.toBoolean(config.getProperties().get("org.apache.sling.installer.configuration.persist"), true);
                        Dictionary<String, Object> dict = ConfigUtil.cleanConfiguration(config.getProperties());
                        HashMap<String, Object> attrs = new HashMap<String, Object>();
                        if (!persist) {
                            attrs.put("org.apache.sling.installer.api.persist", Boolean.FALSE);
                        }
                        attrs.put("service.pid", event.getPid());
                        attrs.put("resource.uri.hint", event.getPid());
                        if (config.getBundleLocation() != null) {
                            attrs.put("installation.hint", config.getBundleLocation());
                        }
                        if (event.getFactoryPid() != null) {
                            attrs.put("service.factoryPid", event.getFactoryPid());
                        }
                        this.changeListener.resourceAddedOrUpdated("config", event.getPid(), null, dict, attrs);
                    } else {
                        this.logger.debug("Ignoring configuration event for {}:{}", (Object)event.getPid(), (Object)event.getFactoryPid());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public TransformationResult[] transform(RegisteredResource resource) {
        if (resource.getType().equals("properties")) {
            return this.checkConfiguration(resource);
        }
        return null;
    }

    private static String getResourceId(String rawUrl) {
        String url = ConfigTaskCreator.separatorsToUnix(rawUrl);
        int pos = url.lastIndexOf(47);
        if (pos == -1) {
            pos = url.indexOf(58);
        }
        String lastIdPart = pos != -1 ? url.substring(pos + 1) : url;
        return lastIdPart;
    }

    private TransformationResult[] checkConfiguration(RegisteredResource resource) {
        String factoryPid;
        String configPid;
        String lastIdPart = ConfigTaskCreator.getResourceId(resource.getURL());
        String pid = ConfigTaskCreator.removeConfigExtension(lastIdPart);
        HashMap<String, String> attr = new HashMap<String, String>();
        int n = pid.indexOf(126);
        if (n == -1) {
            n = pid.indexOf(45);
        }
        if (n > 0) {
            configPid = pid.substring(n + 1);
            factoryPid = pid.substring(0, n);
            attr.put("service.factoryPid", factoryPid);
        } else {
            factoryPid = null;
            configPid = pid;
        }
        attr.put("service.pid", configPid);
        TransformationResult tr = new TransformationResult();
        String id = factoryPid == null ? configPid : ConfigUtil.getPIDOfFactoryPID(factoryPid, configPid);
        tr.setId(id);
        tr.setResourceType("config");
        tr.setAttributes(attr);
        return new TransformationResult[]{tr};
    }

    private static String removeConfigExtension(String id) {
        for (String ext : EXTENSIONS) {
            if (!id.endsWith(ext)) continue;
            return id.substring(0, id.length() - ext.length());
        }
        return id;
    }

    private static String separatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }
}

