/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.io.IOException;
import java.text.MessageFormat;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.factories.configuration.impl.AbstractConfigTask;
import org.apache.sling.installer.factories.configuration.impl.Activator;
import org.apache.sling.installer.factories.configuration.impl.ConfigUtil;
import org.apache.sling.installer.factories.configuration.impl.Coordinator;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigInstallTask
extends AbstractConfigTask {
    private static final String CONFIG_INSTALL_ORDER = "20-";

    public ConfigInstallTask(TaskResourceGroup r, ConfigurationAdmin configAdmin) {
        super(r, configAdmin);
    }

    public String getSortKey() {
        return CONFIG_INSTALL_ORDER + this.getRealPID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(InstallationContext ctx) {
        Coordinator coordinator = Coordinator.SHARED;
        synchronized (coordinator) {
            boolean created = false;
            try {
                String location = (String)this.getResource().getDictionary().get("org.apache.sling.installer.configuration.bundlelocation");
                if (location == null) {
                    location = Activator.DEFAULT_LOCATION;
                } else if (location.length() == 0) {
                    location = null;
                }
                Configuration config = ConfigUtil.getConfiguration(this.getConfigurationAdmin(), this.factoryPid, this.configPid);
                if (config == null) {
                    config = ConfigUtil.createConfiguration(this.getConfigurationAdmin(), this.factoryPid, this.configPid, location);
                    created = true;
                } else if (ConfigUtil.isSameData(config.getProperties(), this.getResource().getDictionary())) {
                    this.getLogger().debug("Configuration {} already installed with same data, update request ignored: {}", (Object)config.getPid(), (Object)this.getResource());
                    config = null;
                } else {
                    config.setBundleLocation(location);
                }
                if (config != null) {
                    config.update(this.getDictionary());
                    ctx.log("Installed configuration {} from resource {}", new Object[]{config.getPid(), this.getResource()});
                    this.getLogger().debug("Configuration " + config.getPid() + " " + (created ? "created" : "updated") + " from " + this.getResource());
                    Coordinator.Operation op = new Coordinator.Operation(config.getPid(), config.getFactoryPid(), false);
                    Coordinator.SHARED.add(op);
                }
                this.setFinishedState(ResourceState.INSTALLED);
            }
            catch (IOException | IllegalStateException e) {
                this.getLogger().debug("Temporary exception during installation of config " + this.getResource() + " : " + e.getMessage() + ". Retrying later.", (Throwable)e);
            }
            catch (Exception e) {
                String message = MessageFormat.format("Exception during installation of config {0} : {1}", this.getResource(), e.getMessage());
                this.getLogger().error(message, (Throwable)e);
                this.setFinishedState(ResourceState.IGNORED, null, message);
            }
        }
    }
}

