/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.util.Hashtable;
import org.apache.sling.installer.api.ResourceChangeListener;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.factories.configuration.impl.ConfigTaskCreator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationListener;

public class ServicesListener {
    public static final String VENDOR = "The Apache Software Foundation";
    private final BundleContext bundleContext;
    private final Listener changeHandlerListener;
    private final Listener configAdminListener;
    private ServiceRegistration configTaskCreatorRegistration;
    private ConfigTaskCreator configTaskCreator;

    public ServicesListener(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.changeHandlerListener = new Listener(ResourceChangeListener.class.getName());
        this.configAdminListener = new Listener(ConfigurationAdmin.class.getName());
        this.changeHandlerListener.start();
        this.configAdminListener.start();
    }

    public synchronized void notifyChange() {
        ResourceChangeListener listener = (ResourceChangeListener)this.changeHandlerListener.getService();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminListener.getService();
        if (configAdmin != null && listener != null) {
            if (this.configTaskCreator == null) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("service.description", "Apache Sling Configuration Install Task Factory");
                props.put("service.vendor", VENDOR);
                this.configTaskCreator = new ConfigTaskCreator(listener, configAdmin);
                String[] serviceInterfaces = new String[]{InstallTaskFactory.class.getName(), ConfigurationListener.class.getName(), ResourceTransformer.class.getName()};
                this.configTaskCreatorRegistration = this.bundleContext.registerService(serviceInterfaces, (Object)this.configTaskCreator, props);
            }
        } else {
            this.stop();
        }
    }

    private void stop() {
        if (this.configTaskCreatorRegistration != null) {
            this.configTaskCreatorRegistration.unregister();
            this.configTaskCreatorRegistration = null;
        }
        this.configTaskCreator = null;
    }

    public void deactivate() {
        this.changeHandlerListener.deactivate();
        this.configAdminListener.deactivate();
        this.stop();
    }

    protected final class Listener
    implements ServiceListener {
        private final String serviceName;
        private ServiceReference reference;
        private Object service;

        public Listener(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() {
            this.retainService();
            try {
                ServicesListener.this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + this.serviceName + ")");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occured.", ise);
            }
        }

        public void deactivate() {
            ServicesListener.this.bundleContext.removeServiceListener((ServiceListener)this);
        }

        public synchronized Object getService() {
            return this.service;
        }

        private synchronized void retainService() {
            if (this.reference == null) {
                this.reference = ServicesListener.this.bundleContext.getServiceReference(this.serviceName);
                if (this.reference != null) {
                    this.service = ServicesListener.this.bundleContext.getService(this.reference);
                    if (this.service == null) {
                        this.reference = null;
                    } else {
                        ServicesListener.this.notifyChange();
                    }
                }
            }
        }

        private synchronized void releaseService() {
            if (this.reference != null) {
                this.service = null;
                ServicesListener.this.bundleContext.ungetService(this.reference);
                this.reference = null;
                ServicesListener.this.notifyChange();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.retainService();
            } else if (event.getType() == 4) {
                this.releaseService();
            }
        }
    }
}

