/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConfigUtil {
    public static final String PROPERTY_DELETE_MARKER = "org.apache.sling.installer.configuration.deleted";
    private static final String CONFIG_PATH_KEY = "org.apache.sling.installer.osgi.path";
    private static final String ALIAS_KEY = "org.apache.sling.installer.osgi.factoryaliaspid";
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();

    ConfigUtil() {
    }

    private static Set<String> collectKeys(Dictionary<String, Object> a) {
        HashSet<String> keys = new HashSet<String>();
        Enumeration<String> aI = a.keys();
        while (aI.hasMoreElements()) {
            String key = aI.nextElement();
            if (IGNORED_PROPERTIES.contains(key)) continue;
            keys.add(key);
        }
        return keys;
    }

    public static boolean isSameData(Dictionary<String, Object> a, Dictionary<String, Object> b) {
        boolean result = false;
        if (a != null && b != null) {
            Set<String> keysA = ConfigUtil.collectKeys(a);
            Set<String> keysB = ConfigUtil.collectKeys(b);
            if (keysA.size() == keysB.size() && keysA.containsAll(keysB)) {
                result = true;
                block0: for (String key : keysA) {
                    Object valA = a.get(key);
                    Object valB = b.get(key);
                    if (valA.getClass().isArray()) {
                        Object[] arrA = (Object[])valA;
                        Object[] arrB = (Object[])valB;
                        if (arrA.length != arrB.length) {
                            result = false;
                            break;
                        }
                        for (int i = 0; i < arrA.length; ++i) {
                            if (String.valueOf(arrA[i]).equals(String.valueOf(arrB[i]))) continue;
                            result = false;
                            continue block0;
                        }
                        continue;
                    }
                    if (String.valueOf(valA).equals(String.valueOf(valB))) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    public static Dictionary<String, Object> cleanConfiguration(Dictionary<String, Object> config) {
        Hashtable<String, Object> cleanedConfig = new Hashtable<String, Object>();
        Enumeration<String> e = config.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (IGNORED_PROPERTIES.contains(key)) continue;
            ((Dictionary)cleanedConfig).put(key, config.get(key));
        }
        return cleanedConfig;
    }

    private static String encode(String value) {
        return value.replace("\\", "\\\\").replace("*", "\\*").replace("(", "\\(").replace(")", "\\)");
    }

    public static Configuration getConfiguration(ConfigurationAdmin ca, String factoryPid, String configPid) throws IOException, InvalidSyntaxException {
        return ConfigUtil.getOrCreateConfiguration(ca, factoryPid, configPid, null, false);
    }

    public static Configuration createConfiguration(ConfigurationAdmin ca, String factoryPid, String configPid, String location) throws IOException, InvalidSyntaxException {
        return ConfigUtil.getOrCreateConfiguration(ca, factoryPid, configPid, location, true);
    }

    private static Configuration getOrCreateConfiguration(ConfigurationAdmin ca, String factoryPid, String configPid, String location, boolean createIfNeeded) throws IOException, InvalidSyntaxException {
        Configuration result = null;
        if (factoryPid == null) {
            if (createIfNeeded) {
                result = ca.getConfiguration(configPid, location);
            } else {
                String filter = "(service.pid=" + ConfigUtil.encode(configPid) + ")";
                Configuration[] configs = ca.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    result = configs[0];
                }
            }
        } else {
            Configuration[] configs = null;
            if (configPid != null) {
                configs = ca.listConfigurations("(&(service.factoryPid=" + ConfigUtil.encode(factoryPid) + ")(" + "service.pid" + "=" + ConfigUtil.encode(configPid) + "))");
            }
            if (configs == null || configs.length == 0) {
                configs = ca.listConfigurations("(&(service.factoryPid=" + factoryPid + ")(" + ALIAS_KEY + "=" + ConfigUtil.encode(configPid) + "))");
                if (configs == null || configs.length == 0) {
                    if (createIfNeeded) {
                        result = ca.createFactoryConfiguration(factoryPid, location);
                    }
                } else {
                    result = configs[0];
                }
            } else {
                result = configs[0];
            }
        }
        return result;
    }

    public static boolean toBoolean(Object obj, boolean defaultValue) {
        boolean result = defaultValue;
        if (obj != null) {
            result = obj instanceof Boolean ? ((Boolean)obj).booleanValue() : Boolean.valueOf(String.valueOf(obj)).booleanValue();
        }
        return result;
    }

    static {
        IGNORED_PROPERTIES.add("service.pid");
        IGNORED_PROPERTIES.add(CONFIG_PATH_KEY);
        IGNORED_PROPERTIES.add(ALIAS_KEY);
        IGNORED_PROPERTIES.add("service.factoryPid");
    }
}

