/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.util.Dictionary;
import java.util.HashMap;
import org.apache.sling.installer.api.ResourceChangeListener;
import org.apache.sling.installer.api.tasks.ChangeStateTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.apache.sling.installer.factories.configuration.impl.ConfigInstallTask;
import org.apache.sling.installer.factories.configuration.impl.ConfigRemoveTask;
import org.apache.sling.installer.factories.configuration.impl.ConfigUtil;
import org.apache.sling.installer.factories.configuration.impl.Coordinator;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTaskCreator
implements InstallTaskFactory,
ConfigurationListener,
ResourceTransformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationAdmin configAdmin;
    private final ResourceChangeListener changeListener;

    public ConfigTaskCreator(ResourceChangeListener listener, ConfigurationAdmin configAdmin) {
        this.changeListener = listener;
        this.configAdmin = configAdmin;
    }

    public InstallTask createTask(TaskResourceGroup group) {
        TaskResource second;
        TaskResource toActivate = group.getActiveResource();
        if (!toActivate.getType().equals("config")) {
            return null;
        }
        Object result = toActivate.getState() == ResourceState.UNINSTALL ? (!((second = group.getNextActiveResource()) == null || second.getState() != ResourceState.IGNORED && second.getState() != ResourceState.INSTALLED && second.getState() != ResourceState.INSTALL || second.getDictionary() != null && second.getDictionary().get("org.apache.sling.installer.api.template") != null) ? new ChangeStateTask(group, ResourceState.UNINSTALLED) : new ConfigRemoveTask(group, this.configAdmin)) : new ConfigInstallTask(group, this.configAdmin);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationEvent(ConfigurationEvent event) {
        Coordinator coordinator = Coordinator.SHARED;
        synchronized (coordinator) {
            String pid;
            String id;
            if (event.getFactoryPid() == null) {
                pid = id = event.getPid();
            } else {
                pid = event.getPid().startsWith(event.getFactoryPid() + '.') ? event.getPid().substring(event.getFactoryPid().length() + 1) : event.getPid();
                id = event.getFactoryPid() + '.' + event.getPid();
            }
            if (event.getType() == 2) {
                Coordinator.Operation op = Coordinator.SHARED.get(event.getPid(), event.getFactoryPid(), true);
                if (op == null) {
                    this.changeListener.resourceRemoved("config", id);
                } else {
                    this.logger.debug("Ignoring configuration event for {}:{}", (Object)event.getPid(), (Object)event.getFactoryPid());
                }
            } else if (event.getType() == 1) {
                try {
                    Configuration config = ConfigUtil.getConfiguration(this.configAdmin, event.getFactoryPid(), event.getPid());
                    Coordinator.Operation op = Coordinator.SHARED.get(event.getPid(), event.getFactoryPid(), false);
                    if (config != null && op == null) {
                        boolean persist = ConfigUtil.toBoolean(config.getProperties().get("org.apache.sling.installer.configuration.persist"), true);
                        Dictionary<String, Object> dict = ConfigUtil.cleanConfiguration(config.getProperties());
                        HashMap<String, Object> attrs = new HashMap<String, Object>();
                        if (!persist) {
                            attrs.put("org.apache.sling.installer.api.persist", Boolean.FALSE);
                        }
                        attrs.put("service.pid", event.getPid());
                        if (event.getFactoryPid() == null) {
                            attrs.put("resource.uri.hint", pid);
                        } else {
                            attrs.put("resource.uri.hint", event.getFactoryPid() + '-' + pid);
                        }
                        if (config.getBundleLocation() != null) {
                            attrs.put("installation.hint", config.getBundleLocation());
                        }
                        if (event.getFactoryPid() != null) {
                            attrs.put("service.factoryPid", event.getFactoryPid());
                        }
                        this.changeListener.resourceAddedOrUpdated("config", id, null, dict, attrs);
                    } else {
                        this.logger.debug("Ignoring configuration event for {}:{}", (Object)event.getPid(), (Object)event.getFactoryPid());
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
    }

    public TransformationResult[] transform(RegisteredResource resource) {
        if (resource.getType().equals("properties")) {
            return this.checkConfiguration(resource);
        }
        return null;
    }

    private TransformationResult[] checkConfiguration(RegisteredResource resource) {
        String factoryPid;
        String configPid;
        String pid;
        String url = ConfigTaskCreator.separatorsToUnix(resource.getURL());
        String lastIdPart = url;
        int pos = lastIdPart.lastIndexOf(47);
        if (pos != -1) {
            lastIdPart = lastIdPart.substring(pos + 1);
        }
        if (ConfigTaskCreator.isConfigExtension(ConfigTaskCreator.getExtension(lastIdPart))) {
            int lastDot = lastIdPart.lastIndexOf(46);
            pid = lastIdPart.substring(0, lastDot);
        } else {
            pid = lastIdPart;
        }
        int n = pid.indexOf(45);
        if (n > 0) {
            String fString = pid.substring(0, n);
            String cString = pid.substring(n + 1);
            boolean useExtendedPid = false;
            try {
                if (ConfigUtil.getConfiguration(this.configAdmin, fString, fString + '.' + cString) != null) {
                    useExtendedPid = true;
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            configPid = useExtendedPid ? fString + '.' + cString : pid.substring(n + 1);
            factoryPid = pid.substring(0, n);
        } else {
            factoryPid = null;
            configPid = pid;
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("service.pid", configPid);
        if (factoryPid != null) {
            attr.put("service.factoryPid", factoryPid);
        }
        TransformationResult tr = new TransformationResult();
        String id = (factoryPid == null ? "" : factoryPid + ".") + configPid;
        tr.setId(id);
        tr.setResourceType("config");
        tr.setAttributes(attr);
        return new TransformationResult[]{tr};
    }

    private static String getExtension(String url) {
        int pos = url.lastIndexOf(46);
        return pos < 0 ? "" : url.substring(pos + 1);
    }

    private static boolean isConfigExtension(String extension) {
        return extension.equals("cfg") || extension.equals("config") || extension.equals("xml") || extension.equals("properties");
    }

    private static String separatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }
}

