/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.factories.configuration.impl.ConfigUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractConfigTask
extends InstallTask {
    protected final String configPid;
    protected final String factoryPid;
    protected String aliasPid;
    private final ConfigurationAdmin configAdmin;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    AbstractConfigTask(TaskResourceGroup r, ConfigurationAdmin configAdmin) {
        super(r);
        this.configAdmin = configAdmin;
        this.configPid = (String)this.getResource().getAttribute("service.pid");
        this.factoryPid = (String)this.getResource().getAttribute("service.factoryPid");
        this.aliasPid = r.getAlias() != null ? r.getAlias().substring(this.factoryPid.length() + 1) : null;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdmin;
    }

    protected String getCompositePid() {
        return (this.factoryPid == null ? "" : this.factoryPid + ".") + this.configPid;
    }

    protected String getCompositeAliasPid() {
        if (this.aliasPid == null || this.factoryPid == null) {
            return null;
        }
        String alias = this.factoryPid + "." + this.aliasPid;
        int pos = this.getResource().getEntityId().indexOf(58);
        if (this.getResource().getEntityId().substring(pos + 1).equals(alias)) {
            return null;
        }
        return alias;
    }

    protected Dictionary<String, Object> getDictionary() {
        return this.getResource().getDictionary();
    }

    protected Configuration getConfiguration() throws IOException, InvalidSyntaxException {
        return ConfigUtil.getConfiguration(this.configAdmin, this.factoryPid, this.factoryPid != null && this.aliasPid != null ? this.aliasPid : this.configPid);
    }

    protected Configuration createConfiguration(String location) throws IOException, InvalidSyntaxException {
        return ConfigUtil.createConfiguration(this.configAdmin, this.factoryPid, this.factoryPid != null && this.aliasPid != null ? this.aliasPid : this.configPid, location);
    }
}

