/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.configurator.json;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonStructure;
import org.apache.sling.installer.core.impl.configurator.json.BinUtil;
import org.apache.sling.installer.core.impl.configurator.json.JSONUtil;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.ConverterFunction;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.osgi.util.converter.TargetRule;
import org.osgi.util.converter.TypeReference;

public class TypeConverter {
    private static final Map<String, Class<?>> TYPE_MAP = new HashMap();
    private final List<File> allFiles = new ArrayList<File>();
    private final List<File> files = new ArrayList<File>();
    private final BinUtil.ResourceProvider provider;

    public static Converter getConverter() {
        return Converters.standardConverter().newConverterBuilder().rule(new TargetRule(){

            public Type getTargetType() {
                return String.class;
            }

            public ConverterFunction getFunction() {
                return new ConverterFunction(){

                    public Object apply(Object obj, Type targetType) throws Exception {
                        if (obj instanceof Map || obj instanceof List) {
                            JsonStructure json = JSONUtil.build(obj);
                            StringWriter w = new StringWriter();
                            Json.createWriter((Writer)w).write(json);
                            return w.toString();
                        }
                        return CANNOT_HANDLE;
                    }
                };
            }
        }).build();
    }

    public TypeConverter(BinUtil.ResourceProvider provider) {
        this.provider = provider;
    }

    public Object convert(String pid, Object value, String typeInfo) throws IOException {
        if (typeInfo == null) {
            if (value instanceof String || value instanceof Boolean) {
                return value;
            }
            if (value instanceof Long || value instanceof Double) {
                return value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof Short) {
                return ((Short)value).longValue();
            }
            if (value instanceof Byte) {
                return ((Byte)value).longValue();
            }
            if (value instanceof Float) {
                return ((Float)value).doubleValue();
            }
            if (value instanceof List) {
                List list = (List)value;
                if (list.isEmpty()) {
                    return new String[0];
                }
                Object firstObject = list.get(0);
                boolean hasListOrMap = false;
                for (Object v : list) {
                    if (!(v instanceof List) && !(v instanceof Map)) continue;
                    hasListOrMap = true;
                    break;
                }
                Object convertedValue = null;
                if (!hasListOrMap) {
                    if (firstObject instanceof Boolean) {
                        convertedValue = ((Converting)TypeConverter.getConverter().convert((Object)list).defaultValue(null)).to(Boolean[].class);
                    } else if (firstObject instanceof Long || firstObject instanceof Integer || firstObject instanceof Byte || firstObject instanceof Short) {
                        convertedValue = ((Converting)TypeConverter.getConverter().convert((Object)list).defaultValue(null)).to(Long[].class);
                    } else if (firstObject instanceof Double || firstObject instanceof Float) {
                        convertedValue = ((Converting)TypeConverter.getConverter().convert((Object)list).defaultValue(null)).to(Double[].class);
                    }
                }
                if (convertedValue == null) {
                    convertedValue = ((Converting)TypeConverter.getConverter().convert((Object)list).defaultValue(null)).to(String[].class);
                }
                return convertedValue;
            }
            return null;
        }
        if ("binary".equals(typeInfo)) {
            File filePath;
            if (this.provider == null) {
                throw new IOException("Binary files only allowed within a bundle");
            }
            String path = (String)((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to(String.class);
            if (path == null) {
                throw new IOException("Invalid path for binary property: " + value);
            }
            try {
                filePath = BinUtil.extractFile(this.provider, pid, path);
            }
            catch (IOException ioe) {
                throw new IOException("Unable to read " + path + " in bundle " + this.provider.getIdentifier() + " for pid " + pid + " and write to " + BinUtil.binDirectory + " : " + ioe.getMessage(), ioe);
            }
            if (filePath == null) {
                throw new IOException("Entry " + path + " not found in bundle " + this.provider.getIdentifier());
            }
            this.files.add(filePath);
            this.allFiles.add(filePath);
            return filePath.getAbsolutePath();
        }
        if ("binary[]".equals(typeInfo)) {
            if (this.provider == null) {
                throw new IOException("Binary files only allowed within a bundle");
            }
            String[] paths = (String[])((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to(String[].class);
            if (paths == null) {
                throw new IOException("Invalid paths for binary[] property: " + value);
            }
            String[] filePaths = new String[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                File filePath;
                try {
                    filePath = BinUtil.extractFile(this.provider, pid, paths[i]);
                }
                catch (IOException ioe) {
                    throw new IOException("Unable to read " + paths[i] + " in bundle " + this.provider.getIdentifier() + " for pid " + pid + " and write to " + BinUtil.binDirectory + " : " + ioe.getMessage(), ioe);
                }
                if (filePath == null) {
                    throw new IOException("Entry " + paths[i] + " not found in bundle " + this.provider.getIdentifier());
                }
                this.files.add(filePath);
                this.allFiles.add(filePath);
                filePaths[i] = filePath.getAbsolutePath();
            }
            return filePaths;
        }
        Class<?> typeClass = TYPE_MAP.get(typeInfo);
        if (typeClass != null) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to(typeClass);
        }
        if ("Collection<String>".equals(typeInfo)) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<String>>(){});
        }
        if ("Collection<Integer>".equals(typeInfo)) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Integer>>(){});
        }
        if ("Collection<Long>".equals(typeInfo)) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Long>>(){});
        }
        if ("Collection<Float>".equals(typeInfo)) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Float>>(){});
        }
        if ("Collection<Double>".equals(typeInfo)) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Double>>(){});
        }
        if ("Collection<Byte>".equals(typeInfo)) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Byte>>(){});
        }
        if ("Collection<Short>".equals(typeInfo)) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Short>>(){});
        }
        if ("Collection<Character>".equals(typeInfo)) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Character>>(){});
        }
        if ("Collection<Boolean>".equals(typeInfo)) {
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Boolean>>(){});
        }
        if ("Collection".equals(typeInfo)) {
            if (value instanceof List) {
                List list = (List)value;
                if (list.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                Object firstObject = list.get(0);
                boolean hasListOrMap = false;
                for (Object v : list) {
                    if (!(v instanceof List) && !(v instanceof Map)) continue;
                    hasListOrMap = true;
                    break;
                }
                Object convertedValue = null;
                if (!hasListOrMap) {
                    if (firstObject instanceof Boolean) {
                        convertedValue = ((Converting)TypeConverter.getConverter().convert((Object)list).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Boolean>>(){});
                    } else if (firstObject instanceof Long || firstObject instanceof Integer || firstObject instanceof Byte || firstObject instanceof Short) {
                        convertedValue = ((Converting)TypeConverter.getConverter().convert((Object)list).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Long>>(){});
                    } else if (firstObject instanceof Double || firstObject instanceof Float) {
                        convertedValue = ((Converting)TypeConverter.getConverter().convert((Object)list).defaultValue(null)).to((TypeReference)new TypeReference<ArrayList<Double>>(){});
                    }
                }
                if (convertedValue == null) {
                    convertedValue = ((Converting)TypeConverter.getConverter().convert((Object)list).defaultValue(null)).to((TypeReference)new TypeReference<List<String>>(){});
                }
                return convertedValue;
            }
            return ((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to(ArrayList.class);
        }
        throw new IOException("Invalid type information: " + typeInfo);
    }

    public void cleanupFiles() {
        for (File f : this.allFiles) {
            f.delete();
        }
    }

    public List<File> flushFiles() {
        if (this.files.isEmpty()) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>(this.files);
        this.files.clear();
        return result;
    }

    static {
        TYPE_MAP.put("String", String.class);
        TYPE_MAP.put("Integer", Integer.class);
        TYPE_MAP.put("int", Integer.class);
        TYPE_MAP.put("Long", Long.class);
        TYPE_MAP.put("long", Long.class);
        TYPE_MAP.put("Float", Float.class);
        TYPE_MAP.put("float", Float.class);
        TYPE_MAP.put("Double", Double.class);
        TYPE_MAP.put("double", Double.class);
        TYPE_MAP.put("Byte", Byte.class);
        TYPE_MAP.put("byte", Byte.class);
        TYPE_MAP.put("Short", Short.class);
        TYPE_MAP.put("short", Short.class);
        TYPE_MAP.put("Character", Character.class);
        TYPE_MAP.put("char", Character.class);
        TYPE_MAP.put("Boolean", Boolean.class);
        TYPE_MAP.put("boolean", Boolean.class);
        TYPE_MAP.put("String[]", String[].class);
        TYPE_MAP.put("Integer[]", Integer[].class);
        TYPE_MAP.put("int[]", int[].class);
        TYPE_MAP.put("Long[]", Long[].class);
        TYPE_MAP.put("long[]", long[].class);
        TYPE_MAP.put("Float[]", Float[].class);
        TYPE_MAP.put("float[]", float[].class);
        TYPE_MAP.put("Double[]", Double[].class);
        TYPE_MAP.put("double[]", double[].class);
        TYPE_MAP.put("Byte[]", Byte[].class);
        TYPE_MAP.put("byte[]", byte[].class);
        TYPE_MAP.put("Short[]", Short[].class);
        TYPE_MAP.put("short[]", short[].class);
        TYPE_MAP.put("Boolean[]", Boolean[].class);
        TYPE_MAP.put("boolean[]", boolean[].class);
        TYPE_MAP.put("Character[]", Character[].class);
        TYPE_MAP.put("char[]", char[].class);
    }
}

