/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.core.impl.FileDataStore;
import org.apache.sling.installer.core.impl.configurator.json.JSONUtil;
import org.apache.sling.installer.core.impl.configurator.json.TypeConverter;
import org.apache.sling.installer.core.impl.configurator.model.ConfigurationFile;
import org.apache.sling.installer.core.impl.felix.cm.ConfigurationHandler;

public class InternalResource
extends InstallableResource {
    private final String url;
    private File dataFile;
    private final String resourceUri;
    private static final List<String> EXTENSIONS = Arrays.asList(".config", ".properties", ".cfg", ".cfg.json");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalResource create(String scheme, InstallableResource resource) throws IOException {
        String digest;
        boolean useResourceUri;
        InputStream is = resource.getInputStream();
        Dictionary<String, Object> dict = resource.getDictionary();
        String type = resource.getType();
        if ("bundle".equals(type)) {
            type = "file";
        } else if ("config".equals(type)) {
            type = "properties";
        }
        String resourceUri = dict != null && (type == null || "file".equals(type)) && resource.getDigest() != null && resource.getDigest().length() > 0 ? (String)dict.get("resource.uri.hint") : null;
        boolean bl = useResourceUri = resourceUri != null;
        if (resourceUri != null) {
            InputStream resourceUriIS = null;
            try {
                URI uri = new URI(resourceUri);
                resourceUriIS = uri.toURL().openStream();
            }
            catch (Exception use) {
                useResourceUri = false;
            }
            finally {
                if (resourceUriIS != null) {
                    try {
                        resourceUriIS.close();
                    }
                    catch (IOException use) {}
                }
            }
        }
        if (is != null && ("properties".equals(type) || (type == null || "file".equals(type)) && InternalResource.isConfigExtension(resource.getId()))) {
            try {
                dict = InternalResource.readDictionary(is, scheme, resource.getId());
            }
            catch (IOException ioe) {
                throw (IOException)new IOException("Unable to read dictionary from input stream: " + resource.getId()).initCause(ioe);
            }
            is = null;
            useResourceUri = false;
        }
        File dataFile = null;
        if (is == null) {
            type = type != null ? type : "properties";
            digest = FileDataStore.computeDigest(dict);
        } else {
            String string = type = type != null ? type : "file";
            if (resourceUri != null && useResourceUri) {
                digest = resource.getDigest();
            } else {
                String url = scheme + ':' + resource.getId();
                dataFile = FileDataStore.SHARED.createNewDataFile(is, url, resource.getDigest(), resource.getType());
                if (resource.getDigest() != null && resource.getDigest().length() > 0) {
                    digest = resource.getDigest();
                } else {
                    digest = FileDataStore.computeDigest(dataFile);
                    FileDataStore.SHARED.updateDigestCache(url, dataFile, digest);
                }
            }
        }
        return new InternalResource(scheme, resource.getId(), is, dict, type, digest, resource.getPriority(), dataFile, useResourceUri ? resourceUri : null);
    }

    public InternalResource(String scheme, String id, InputStream is, Dictionary<String, Object> dict, String type, String digest, Integer priority, File dataFile, String resourceUri) {
        super(id, is, dict, digest, type, priority);
        this.url = scheme + ':' + id;
        this.dataFile = dataFile;
        this.resourceUri = resourceUri;
    }

    public String getURL() {
        return this.url;
    }

    public Dictionary<String, Object> getPrivateCopyOfDictionary() {
        Dictionary<String, Object> d = this.getDictionary();
        if (d == null) {
            return null;
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        Enumeration<String> e = d.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            ((Dictionary)result).put(key, d.get(key));
        }
        return result;
    }

    public File getPrivateCopyOfFile() {
        return this.dataFile;
    }

    public void setPrivateCopyOfFile(File file) {
        this.dataFile = file;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    private static Dictionary<String, Object> readDictionary(InputStream is, String scheme, String id) throws IOException {
        if (id.endsWith(".cfg.json")) {
            String contents;
            String name = scheme.concat(":").concat(id);
            int pos = id.lastIndexOf(47);
            String configId = pos == -1 ? id : id.substring(pos + 1);
            pos = configId.indexOf(45);
            if (pos != -1) {
                configId = configId.substring(0, pos).concat("~").concat(configId.substring(pos + 1));
            }
            configId = InternalResource.removeConfigExtension(configId);
            TypeConverter typeConverter = new TypeConverter(null);
            JSONUtil.Report report = new JSONUtil.Report();
            try (BufferedReader buf = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                String line;
                StringBuilder sb = new StringBuilder();
                sb.append("{ \"");
                sb.append(configId);
                sb.append("\" : ");
                while ((line = buf.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
                sb.append("}");
                contents = sb.toString();
            }
            URL url = new URL("file://" + configId);
            ConfigurationFile config = JSONUtil.readJSON(typeConverter, name, url, 0L, contents, report);
            if (!report.errors.isEmpty() || !report.warnings.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Errors in configuration:");
                for (String w : report.warnings) {
                    builder.append("\n");
                    builder.append(w);
                }
                for (String e : report.errors) {
                    builder.append("\n");
                    builder.append(e);
                }
                throw new IOException(builder.toString());
            }
            return config.getConfigurations().get(0).getProperties();
        }
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        try (BufferedInputStream in = new BufferedInputStream(is);){
            if (id.endsWith(".config")) {
                in.mark(256);
                int firstChar = in.read();
                if (firstChar == 35) {
                    int b;
                    while ((b = in.read()) != 10) {
                        if (b != -1) continue;
                        throw new IOException("Unable to read configuration.");
                    }
                } else {
                    in.reset();
                }
                Dictionary config = ConfigurationHandler.read(in);
                Enumeration i = config.keys();
                while (i.hasMoreElements()) {
                    String key = (String)i.nextElement();
                    ht.put(key, config.get(key));
                }
            } else {
                Properties p = new Properties();
                in.mark(1);
                boolean isXml = in.read() == 60;
                in.reset();
                if (isXml) {
                    p.loadFromXML(in);
                } else {
                    p.load(in);
                }
                Enumeration<Object> i = p.keys();
                while (i.hasMoreElements()) {
                    Object key = i.nextElement();
                    ht.put(key.toString(), p.get(key));
                }
            }
        }
        return ht;
    }

    private static boolean isConfigExtension(String url) {
        for (String ext : EXTENSIONS) {
            if (!url.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private static String removeConfigExtension(String id) {
        for (String ext : EXTENSIONS) {
            if (!id.endsWith(ext)) continue;
            return id.substring(0, id.length() - ext.length());
        }
        return id;
    }
}

