/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.installer.api.event.InstallationEvent;
import org.apache.sling.installer.api.event.InstallationListener;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.core.impl.RegisteredResourceImpl;
import org.apache.sling.installer.core.impl.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityResourceList
implements Serializable,
TaskResourceGroup {
    private static final long serialVersionUID = 6L;
    private static final int VERSION = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityResourceList.class);
    private final List<RegisteredResourceImpl> resources = new ArrayList<RegisteredResourceImpl>();
    private String alias;
    private String resourceId;
    private final Object lock = new Object();
    private transient InstallationListener listener;

    public EntityResourceList(String resourceId, InstallationListener listener) {
        this.resourceId = resourceId;
        this.listener = listener;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(2);
        out.writeInt(this.resources.size());
        for (RegisteredResource registeredResource : this.resources) {
            out.writeObject(registeredResource);
        }
        out.writeObject(this.alias);
        out.writeObject(this.resourceId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version < 1 || version > 2) {
            throw new ClassNotFoundException(this.getClass().getName());
        }
        Util.setField(this, "resources", new ArrayList());
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            RegisteredResourceImpl rr = (RegisteredResourceImpl)in.readObject();
            this.resources.add(rr);
        }
        if (version > 1) {
            this.alias = (String)in.readObject();
            this.resourceId = (String)in.readObject();
        }
        Util.setField(this, "lock", new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.resources.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResource getActiveResource() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.resources.isEmpty()) {
                Collections.sort(this.resources);
                TaskResource r = this.resources.get(0);
                if (r.getState() == ResourceState.INSTALL || r.getState() == ResourceState.UNINSTALL) {
                    return r;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResource getNextActiveResource() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getActiveResource() != null && this.resources.size() > 1) {
                Iterator<RegisteredResourceImpl> i = this.resources.iterator();
                i.next();
                return i.next();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<TaskResource> getActiveResourceIterator() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getActiveResource() != null && this.resources.size() > 1) {
                LinkedList<RegisteredResourceImpl> taskResourceList = new LinkedList<RegisteredResourceImpl>(this.resources);
                return taskResourceList.iterator();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResource getFirstResource() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.resources.isEmpty()) {
                Collections.sort(this.resources);
                return this.resources.get(0);
            }
        }
        return null;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public String getFullAlias() {
        if (this.alias != null) {
            int pos = this.resourceId.indexOf(58);
            return this.resourceId.substring(0, pos + 1) + this.alias;
        }
        return null;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String id) {
        this.resourceId = id;
    }

    public void setListener(InstallationListener listener) {
        this.listener = listener;
    }

    public void setForceFinishState(ResourceState state, String error) {
        ((RegisteredResourceImpl)this.getFirstResource()).setState(ResourceState.INSTALL, null);
        this.setFinishState(state, error);
    }

    @Override
    public void setFinishState(ResourceState state) {
        this.setFinishState(state, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFinishState(ResourceState state, String error) {
        final TaskResource toActivate = this.getActiveResource();
        if (toActivate != null) {
            Object object = this.lock;
            synchronized (object) {
                TaskResource rsrc;
                if (toActivate.getState() == ResourceState.UNINSTALL && this.resources.size() > 1) {
                    TaskResource second = this.getNextActiveResource();
                    if (second.getDictionary() != null && second.getDictionary().get("org.apache.sling.installer.api.template") != null) {
                        ((RegisteredResourceImpl)second).setState(ResourceState.IGNORED, null);
                    } else if (state == ResourceState.UNINSTALLED) {
                        if (second.getState() == ResourceState.IGNORED || second.getState() == ResourceState.INSTALLED) {
                            LOGGER.debug("Reactivating for next cycle: {}", (Object)second);
                            ((RegisteredResourceImpl)second).setState(ResourceState.INSTALL, null);
                        }
                    } else {
                        if (second.getState() == ResourceState.INSTALL) {
                            String message = MessageFormat.format("The first resource '{0}' did not get uninstalled, therefore ignore this secondary resource in the uninstall group", toActivate.getEntityId());
                            LOGGER.debug(message);
                            ((RegisteredResourceImpl)second).setState(ResourceState.IGNORED, message);
                        }
                        state = ResourceState.UNINSTALLED;
                    }
                } else if (state == ResourceState.INSTALLED && this.resources.size() > 1) {
                    Iterator<RegisteredResourceImpl> i = this.resources.iterator();
                    i.next();
                    while (i.hasNext()) {
                        rsrc = i.next();
                        if (rsrc.getState() != ResourceState.INSTALLED) continue;
                        ((RegisteredResourceImpl)rsrc).setState(ResourceState.INSTALL, "Another resource with the same entity id but a higher version or priority or digest found (in that order, the latter only in case the version is a SNAPSHOT)!");
                    }
                }
                ((RegisteredResourceImpl)toActivate).setState(state, error);
                if (state != ResourceState.INSTALLED) {
                    toActivate.setAttribute("org.apache.sling.installer.api.resource.install.excluded", null);
                    toActivate.setAttribute("org.apache.sling.installer.api.resource.install.info", null);
                }
                Iterator<RegisteredResourceImpl> tri = this.resources.iterator();
                tri.next();
                while (tri.hasNext()) {
                    rsrc = tri.next();
                    rsrc.setAttribute("org.apache.sling.installer.api.resource.install.excluded", null);
                    rsrc.setAttribute("org.apache.sling.installer.api.resource.install.info", null);
                }
            }
            this.listener.onEvent(new InstallationEvent(){

                @Override
                public InstallationEvent.TYPE getType() {
                    return InstallationEvent.TYPE.PROCESSED;
                }

                @Override
                public Object getSource() {
                    return toActivate;
                }
            });
            if (state == ResourceState.UNINSTALLED) {
                this.cleanup(toActivate);
            }
        }
    }

    @Override
    public void setFinishState(ResourceState state, String alias, String error) {
        if (this.alias == null || alias != null) {
            this.alias = alias;
        }
        this.setFinishState(state, error);
    }

    private void cleanup(RegisteredResource rr) {
        if (rr instanceof RegisteredResourceImpl) {
            ((RegisteredResourceImpl)rr).cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RegisteredResourceImpl> listResources() {
        Object object = this.lock;
        synchronized (object) {
            Collections.sort(this.resources);
            return this.resources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RegisteredResourceImpl> getResources() {
        ArrayList<RegisteredResourceImpl> list;
        Object object = this.lock;
        synchronized (object) {
            list = new ArrayList<RegisteredResourceImpl>(this.resources);
        }
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdate(RegisteredResourceImpl r) {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.debug("Adding new resource: {}", (Object)r);
            Collections.sort(this.resources);
            boolean first = true;
            boolean add = true;
            Iterator<RegisteredResourceImpl> taskIter = this.resources.iterator();
            while (taskIter.hasNext()) {
                TaskResource rr = taskIter.next();
                if (rr.getURL().equals(r.getURL())) {
                    if (RegisteredResourceImpl.isSameResource((RegisteredResourceImpl)rr, r)) {
                        if (!rr.getDigest().equals(r.getDigest())) {
                            LOGGER.debug("Updating resource due to different digests: {} vs {}", (Object)r, (Object)rr);
                            ((RegisteredResourceImpl)rr).updateResourceUri(r.getDataURI());
                            LOGGER.debug("Cleanup duplicate resource: {}", (Object)r);
                            this.cleanup(r);
                        }
                        add = false;
                        break;
                    }
                    if (first && rr.getState() == ResourceState.INSTALLED) {
                        String message = MessageFormat.format("The first resource '{0}' got installed, therefore uninstall this secondary resource in this group", rr.getEntityId());
                        LOGGER.debug(message);
                        ((RegisteredResourceImpl)rr).setState(ResourceState.UNINSTALL, message);
                        break;
                    }
                    LOGGER.debug("Cleanup obsolete resource: {}", (Object)rr);
                    taskIter.remove();
                    this.cleanup(rr);
                    break;
                }
                first = false;
            }
            if (add) {
                this.resources.add(r);
                Collections.sort(this.resources);
                if (r != this.resources.get(0)) {
                    r.setState(ResourceState.INSTALL, "Another resource with the same entity id but a higher version or priority or digest found (in that order, the latter only in case the version is a SNAPSHOT)!");
                }
            }
        }
    }

    public void remove(String url) {
        this.removeInternal(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeInternal(String url) {
        boolean removed = false;
        Object object = this.lock;
        synchronized (object) {
            Collections.sort(this.resources);
            Iterator<RegisteredResourceImpl> i = this.resources.iterator();
            boolean first = true;
            while (i.hasNext()) {
                TaskResource r = i.next();
                if (r.getURL().equals(url)) {
                    removed = true;
                    if (first && (r.getState() == ResourceState.INSTALLED || r.getState() == ResourceState.INSTALL)) {
                        LOGGER.debug("Marking for uninstalling: {}", (Object)r);
                        ((RegisteredResourceImpl)r).setState(ResourceState.UNINSTALL, null);
                    } else {
                        LOGGER.debug("Removing unused: {}", (Object)r);
                        i.remove();
                        this.cleanup(r);
                    }
                }
                first = false;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact() {
        Object object = this.lock;
        synchronized (object) {
            Collections.sort(this.resources);
            boolean startNewCycle = false;
            ArrayList<TaskResource> toDelete = new ArrayList<TaskResource>();
            boolean first = true;
            for (TaskResource taskResource : this.resources) {
                if (taskResource.getState() == ResourceState.UNINSTALLED || !first && taskResource.getState() == ResourceState.UNINSTALL) {
                    toDelete.add(taskResource);
                }
                first = false;
            }
            if (!toDelete.isEmpty()) {
                HashSet<RegisteredResourceImpl> copy = new HashSet<RegisteredResourceImpl>(this.resources);
                for (RegisteredResource registeredResource : toDelete) {
                    copy.remove(registeredResource);
                    this.cleanup(registeredResource);
                    LOGGER.debug("Removing uninstalled from list: {}", (Object)registeredResource);
                }
                this.resources.clear();
                this.resources.addAll(copy);
                if (!this.isEmpty()) {
                    startNewCycle = true;
                }
            }
            return startNewCycle;
        }
    }

    public void update(String newAlias, String newResourceId) {
        this.alias = newAlias;
        this.resourceId = newResourceId;
        for (RegisteredResourceImpl rsrc : this.getResources()) {
            rsrc.updateEntityId(newResourceId);
        }
    }
}

