/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.feature;

import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.sling.installer.core.impl.feature.CloseShieldWriter;

public class ConfiguratorUtil {
    private ConfiguratorUtil() {
    }

    protected static final JsonGenerator newGenerator(Writer writer) {
        JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
        CloseShieldWriter closeShieldWriter = new CloseShieldWriter(writer);
        return generatorFactory.createGenerator((Writer)closeShieldWriter);
    }

    public static void writeConfiguration(Writer writer, Dictionary<String, Object> props) {
        try (JsonGenerator generator = ConfiguratorUtil.newGenerator(writer);){
            generator.writeStartObject();
            ConfiguratorUtil.writeConfiguration(generator, props);
            generator.writeEnd();
        }
    }

    public static void writeConfiguration(JsonGenerator generator, Dictionary<String, Object> props) {
        Enumeration<String> e = props.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            if (":configurator:feature:service.bundleLocation".equals(name)) continue;
            Object val = props.get(name);
            ConfiguratorUtil.writeConfigurationProperty(generator, name, val);
        }
    }

    private static void writeConfigurationProperty(JsonGenerator generator, String name, Object val) {
        String dataType = ConfiguratorUtil.getDataType(val);
        ConfiguratorUtil.writeConfigurationProperty(generator, name, dataType, val);
    }

    private static void writeConfigurationProperty(JsonGenerator generator, String name, String dataType, Object val) {
        String nameWithDataPostFix = name;
        if (dataType != null) {
            nameWithDataPostFix = nameWithDataPostFix + ":" + dataType;
        }
        if (val.getClass().isArray()) {
            generator.writeStartArray(nameWithDataPostFix);
            for (int i = 0; i < Array.getLength(val); ++i) {
                ConfiguratorUtil.writeArrayItem(generator, Array.get(val, i));
            }
            generator.writeEnd();
        } else if (val instanceof Collection) {
            generator.writeStartArray(nameWithDataPostFix);
            for (Object item : (Collection)Collection.class.cast(val)) {
                ConfiguratorUtil.writeArrayItem(generator, item);
            }
            generator.writeEnd();
        } else {
            ConfiguratorUtil.writeNameValuePair(generator, nameWithDataPostFix, val);
        }
    }

    private static void writeNameValuePair(JsonGenerator generator, String name, Object item) {
        if (item instanceof Boolean) {
            generator.write(name, ((Boolean)item).booleanValue());
        } else if (item instanceof Long || item instanceof Integer || item instanceof Byte || item instanceof Short) {
            generator.write(name, ((Number)item).longValue());
        } else if (item instanceof Double) {
            generator.write(name, ((Double)item).doubleValue());
        } else if (item instanceof Float) {
            generator.write(name, (double)((Float)item).floatValue());
        } else {
            generator.write(name, item.toString());
        }
    }

    private static void writeArrayItem(JsonGenerator generator, Object item) {
        if (item instanceof Boolean) {
            generator.write(((Boolean)item).booleanValue());
        } else if (item instanceof Long || item instanceof Integer || item instanceof Byte || item instanceof Short) {
            generator.write(((Number)item).longValue());
        } else if (item instanceof Double) {
            generator.write(((Double)item).doubleValue());
        } else if (item instanceof Float) {
            generator.write((double)((Float)item).floatValue());
        } else {
            generator.write(item.toString());
        }
    }

    private static String getDataType(Object object) {
        if (object instanceof Collection) {
            Iterator it = ((Collection)object).iterator();
            if (it.hasNext()) {
                Class<?> itemClass = it.next().getClass();
                return "Collection<" + ConfiguratorUtil.getDataType(itemClass, false) + ">";
            }
            throw new IllegalStateException("Empty collections are invalid");
        }
        return ConfiguratorUtil.getDataType(object.getClass(), true);
    }

    private static String getDataType(Class<?> clazz, boolean allowEmpty) {
        if (clazz.isArray()) {
            String dataType = ConfiguratorUtil.getDataType(clazz.getComponentType(), false);
            if (dataType != null) {
                return dataType + "[]";
            }
            return null;
        }
        if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE) || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE) || clazz.isAssignableFrom(String.class) ? !allowEmpty : clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE) || clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Byte.TYPE) || clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Short.TYPE) || clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(Character.TYPE)) {
            return clazz.getSimpleName();
        }
        if (!allowEmpty) {
            throw new IllegalStateException("Class does not have a valid type " + clazz);
        }
        return null;
    }
}

