/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.configurator.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sling.installer.core.impl.configurator.model.AbstractState;
import org.apache.sling.installer.core.impl.configurator.model.Config;
import org.apache.sling.installer.core.impl.configurator.model.ConfigList;

public class State
extends AbstractState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;
    public static final String FILE_NAME = "state.ser";
    private Map<Long, Long> bundlesLastModified = new HashMap<Long, Long>();
    private Map<Long, Long> bundlesConfigAdminBundleId = new HashMap<Long, Long>();
    private volatile Set<String> initialHashes;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.bundlesLastModified);
        out.writeObject(this.bundlesConfigAdminBundleId);
        out.writeObject(this.initialHashes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new ClassNotFoundException(this.getClass().getName());
        }
        this.bundlesLastModified = (Map)in.readObject();
        this.bundlesConfigAdminBundleId = (Map)in.readObject();
        this.initialHashes = (Set)in.readObject();
    }

    public static State createOrReadState(File f) throws ClassNotFoundException, IOException {
        if (f == null || !f.exists()) {
            return new State();
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));){
            State state = (State)ois.readObject();
            return state;
        }
    }

    public static void writeState(File f, State state) throws IOException {
        if (f == null) {
            return;
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));){
            oos.writeObject(state);
        }
    }

    public Long getLastModified(long bundleId) {
        return this.bundlesLastModified.get(bundleId);
    }

    public void setLastModified(long bundleId, long lastModified) {
        this.bundlesLastModified.put(bundleId, lastModified);
    }

    public void removeLastModified(long bundleId) {
        this.bundlesLastModified.remove(bundleId);
    }

    public Long getConfigAdminBundleId(long bundleId) {
        return this.bundlesConfigAdminBundleId.get(bundleId);
    }

    public void setConfigAdminBundleId(long bundleId, long lastModified) {
        this.bundlesConfigAdminBundleId.put(bundleId, lastModified);
    }

    public void removeConfigAdminBundleId(long bundleId) {
        this.bundlesConfigAdminBundleId.remove(bundleId);
    }

    public Set<Long> getKnownBundleIds() {
        return this.bundlesLastModified.keySet();
    }

    public Set<String> getInitialHashes() {
        return this.initialHashes;
    }

    public void setInitialHashes(Set<String> value) {
        this.initialHashes = value;
    }

    public void addAll(String pid, ConfigList configs) {
        if (configs != null) {
            ConfigList list = this.getConfigurations().get(pid);
            if (list == null) {
                list = new ConfigList();
                this.getConfigurations().put(pid, list);
            }
            list.addAll(configs);
        }
    }

    public void checkEnvironments(long bundleId) {
        block0: for (String pid : this.getPids()) {
            ConfigList configList = this.getConfigurations(pid);
            for (Config cfg : configList) {
                if (cfg.getBundleId() != bundleId) continue;
                configList.setHasChanges(true);
                continue block0;
            }
        }
    }

    public String toString() {
        return "State [bundlesLastModified=" + this.bundlesLastModified + ", initialHashes=" + this.initialHashes + ", bundlesConfigAdminBundleId=" + this.bundlesConfigAdminBundleId + "]";
    }

    public Set<Long> getBundleIdsUsingConfigAdmin() {
        return new HashSet<Long>(this.bundlesConfigAdminBundleId.keySet());
    }
}

