/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.util;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RefreshDependenciesUtil {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PackageAdmin pckAdmin;

    public RefreshDependenciesUtil(PackageAdmin pa) {
        this.pckAdmin = pa;
    }

    boolean isBundleAffected(Bundle target, List<Bundle> bundles) {
        this.log.debug("isBundleAffected({}, {})", (Object)target, bundles);
        ArrayList<Long> idChecked = new ArrayList<Long>();
        for (Bundle b : bundles) {
            if (!this.dependsOn(idChecked, target, b)) continue;
            this.log.debug("isBundleAffected({}) is true, dependency on bundle {}", (Object)target, (Object)b);
            return true;
        }
        this.log.debug("isBundleAffected({}) is false, no dependencies on {}", (Object)target, bundles);
        return false;
    }

    private boolean dependsOn(List<Long> idChecked, Bundle target, Bundle source) {
        if (idChecked.contains(source.getBundleId())) {
            return false;
        }
        idChecked.add(source.getBundleId());
        ExportedPackage[] eps = this.pckAdmin.getExportedPackages(source);
        if (eps == null) {
            return false;
        }
        for (ExportedPackage ep : eps) {
            Bundle[] importers = ep.getImportingBundles();
            if (importers == null) continue;
            for (Bundle b : importers) {
                if (b.getBundleId() == target.getBundleId()) {
                    this.log.debug("{} depends on {} via package {}", new Object[]{target, source, ep.getName()});
                    return true;
                }
                if (!this.dependsOn(idChecked, target, b)) continue;
                this.log.debug("{} depends on {} which depends on {}, returning true", new Object[]{target, b, source});
                return true;
            }
        }
        return false;
    }
}

