/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.installer.api.UpdateHandler;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.core.impl.InstallerResourceUrlHandler;
import org.apache.sling.installer.core.impl.SortingServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;

public class UpdateHandlerTracker
extends SortingServiceTracker<UpdateHandler> {
    private final InfoProvider infoProvider;
    private final Map<String, AtomicInteger> schemeUseCount;
    private ServiceRegistration<URLStreamHandlerService> urlHandler;

    public UpdateHandlerTracker(BundleContext ctx, InfoProvider infoProvider) {
        super(ctx, UpdateHandler.class.getName(), null);
        this.infoProvider = infoProvider;
        this.urlHandler = null;
        this.schemeUseCount = new HashMap<String, AtomicInteger>();
    }

    @Override
    public Object addingService(ServiceReference reference) {
        this.addOrRemoveService(reference, true);
        return super.addingService(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.addOrRemoveService(reference, false);
        super.removedService(reference, service);
    }

    private void addOrRemoveService(ServiceReference reference, boolean isAdd) {
        String[] schemes = PropertiesUtil.toStringArray((Object)reference.getProperty("handler.schemes"));
        if (schemes != null && schemes.length > 0) {
            boolean hasChanged = false;
            for (String scheme : schemes) {
                if (isAdd) {
                    if (!this.addScheme(scheme)) continue;
                    hasChanged = true;
                    continue;
                }
                if (!this.removeScheme(scheme)) continue;
                hasChanged = true;
            }
            if (hasChanged) {
                this.updateUrlStreamHandler();
            }
        }
    }

    private synchronized void updateUrlStreamHandler() {
        if (this.schemeUseCount.isEmpty()) {
            if (this.urlHandler != null) {
                this.urlHandler.unregister();
            }
        } else if (this.urlHandler == null) {
            InstallerResourceUrlHandler service = new InstallerResourceUrlHandler(this.infoProvider);
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
            ((Dictionary)properties).put("url.handler.protocol", this.schemeUseCount.keySet().toArray(new String[0]));
            this.urlHandler = this.context.registerService(URLStreamHandlerService.class, (Object)service, properties);
        } else {
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
            ((Dictionary)properties).put("url.handler.protocol", this.schemeUseCount.keySet().toArray(new String[0]));
            this.urlHandler.setProperties(properties);
        }
    }

    private synchronized boolean addScheme(String scheme) {
        AtomicInteger useCount = this.schemeUseCount.get(scheme);
        if (useCount == null) {
            this.schemeUseCount.put(scheme, new AtomicInteger(1));
            return true;
        }
        useCount.incrementAndGet();
        return false;
    }

    private synchronized boolean removeScheme(String scheme) {
        AtomicInteger useCount = this.schemeUseCount.get(scheme);
        if (useCount != null && useCount.decrementAndGet() <= 0) {
            this.schemeUseCount.remove(scheme);
            return true;
        }
        return false;
    }

    public void close() {
        this.schemeUseCount.clear();
        this.updateUrlStreamHandler();
        super.close();
    }
}

