/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.sling.installer.api.serializer.ConfigurationSerializer;
import org.jetbrains.annotations.NotNull;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;

public class PropertiesConfigurationSerializer
implements ConfigurationSerializer {
    private final boolean isXml;

    public PropertiesConfigurationSerializer(boolean isXml) {
        this.isXml = isXml;
    }

    @Override
    public void serialize(@NotNull Dictionary<String, Object> dictionary, @NotNull OutputStream outputStream) throws IOException {
        Converter converter = Converters.standardConverter();
        Properties properties = (Properties)converter.convert(dictionary).to(Properties.class);
        if (!this.isXml) {
            properties.store(outputStream, null);
        } else {
            properties.storeToXML(outputStream, null);
        }
    }
}

