/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.util.HashMap;
import org.apache.sling.installer.api.ResourceChangeListener;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.api.tasks.RetryHandler;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.apache.sling.installer.core.impl.InternalService;
import org.apache.sling.installer.core.impl.Util;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransformer
implements InternalService,
ResourceTransformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void init(BundleContext bctx, ResourceChangeListener rcl, RetryHandler retryHandler) {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public String getDescription() {
        return "Apache Sling Installer - Default Resource Transformer";
    }

    @Override
    public TransformationResult[] transform(RegisteredResource resource) {
        this.logger.debug("Trying to transform {} : {}", (Object)resource, (Object)resource.getType());
        if (resource.getType().equals("file")) {
            return this.checkBundle(resource);
        }
        this.logger.debug("Unsupported type {} : {}", (Object)resource, (Object)resource.getType());
        return null;
    }

    private TransformationResult[] checkBundle(RegisteredResource resource) {
        if (!resource.getURL().endsWith(".jar")) {
            this.logger.debug("Skip transforming non jar resource {}", (Object)resource.getURL());
            return null;
        }
        this.logger.debug("Checking headers for {}", (Object)resource);
        Util.BundleHeaders headers = Util.readBundleHeaders(resource, this.logger);
        this.logger.debug("Found headers for {} : {}", (Object)resource, (Object)headers);
        if (headers != null) {
            boolean validVersion = true;
            try {
                new Version(headers.version);
            }
            catch (IllegalArgumentException iae) {
                this.logger.info("Rejecting bundle {} from {} due to invalid version information: {}.", new Object[]{headers.symbolicName, resource, headers.version});
                validVersion = false;
            }
            if (validVersion) {
                HashMap<String, Object> attr = new HashMap<String, Object>();
                attr.put("Bundle-SymbolicName", headers.symbolicName);
                attr.put("Bundle-Version", headers.version);
                if (headers.activationPolicy != null) {
                    attr.put("Bundle-ActivationPolicy", headers.activationPolicy);
                }
                TransformationResult tr = new TransformationResult();
                tr.setId(headers.symbolicName);
                tr.setResourceType("bundle");
                tr.setAttributes(attr);
                this.logger.debug("Transformed {} to {}", (Object)resource, (Object)tr);
                return new TransformationResult[]{tr};
            }
        }
        return null;
    }
}

