/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXHandler;
import org.apache.jackrabbit.vault.fs.impl.io.NodeStash;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JcrSysViewTransformer
implements DocViewAdapter {
    private static final Logger log = LoggerFactory.getLogger(JcrSysViewTransformer.class);
    private static final Name NAME_REP_CACHE = NameFactoryImpl.getInstance().create("internal", "cache");
    private ContentHandler handler;
    private NodeStash recovery;
    private Name rootName;
    private Node parent;
    private final String existingPath;
    private final Set<Name> excludedNodeNames = new HashSet<Name>();
    @NotNull
    private final ImportMode importMode;
    private final NamePathResolver resolver;
    private long ignoreLevel = 0L;

    public JcrSysViewTransformer(@NotNull Node node, @NotNull ImportMode importMode) throws RepositoryException {
        this(node, null, importMode);
    }

    JcrSysViewTransformer(@NotNull Node node, @Nullable String existingPath, @NotNull ImportMode importMode) throws RepositoryException {
        Session session = node.getSession();
        this.parent = node;
        this.handler = session.getImportContentHandler(node.getPath(), existingPath != null ? 2 : 1);
        String[] prefixes = session.getNamespacePrefixes();
        try {
            this.handler.startDocument();
            for (String prefix : prefixes) {
                this.handler.startPrefixMapping(prefix, session.getNamespaceURI(prefix));
            }
        }
        catch (SAXException e) {
            throw new RepositoryException("Can not use sysview handler", e);
        }
        this.existingPath = existingPath;
        if (existingPath != null) {
            this.recovery = new NodeStash(session, existingPath).excludeName("rep:cache");
            this.recovery.stash();
        }
        this.excludeNode(NAME_REP_CACHE);
        this.importMode = importMode;
        this.resolver = new DefaultNamePathResolver(session);
    }

    @Override
    public List<String> close() throws InvalidSerializedDataException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new InvalidSerializedDataException("Invalid sysview", e);
        }
        ArrayList<String> paths = new ArrayList<String>();
        try {
            if (this.existingPath != null && this.parent.getSession().nodeExists(this.existingPath)) {
                this.addPaths(paths, this.parent.getSession().getNode(this.existingPath));
            } else if (this.rootName != null && this.parent.hasNode(this.rootName.toString())) {
                this.addPaths(paths, this.parent.getNode(this.rootName.toString()));
            }
        }
        catch (RepositoryException e) {
            log.error("error while retrieving list of created nodes.");
        }
        if (this.recovery != null) {
            try {
                this.recovery.recover(this.importMode, null);
            }
            catch (RepositoryException e) {
                log.error("Error while processing rescued child nodes");
            }
            finally {
                this.recovery = null;
            }
        }
        return paths;
    }

    private void addPaths(List<String> paths, Node node) throws RepositoryException {
        paths.add(node.getPath());
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            this.addPaths(paths, iter.nextNode());
        }
    }

    @Override
    public void startNode(DocViewNode2 ni) throws RepositoryException {
        if (this.ignoreLevel > 0L) {
            DocViewSAXHandler.log.trace("ignoring child node of excluded node: {}", (Object)ni.getName());
            ++this.ignoreLevel;
            return;
        }
        if (this.excludedNodeNames.contains(ni.getName())) {
            DocViewSAXHandler.log.trace("Ignoring excluded node {}", (Object)ni.getName());
            this.ignoreLevel = 1L;
            return;
        }
        DocViewSAXHandler.log.trace("Transforming element to sysview {}", (Object)ni.getName());
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", this.resolver.getJCRName(ni.getName()));
            this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node", attrs);
            for (DocViewProperty2 p : ni.getProperties()) {
                if (!p.getStringValue().isPresent()) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", this.resolver.getJCRName(p.getName()));
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "type", "sv:type", "CDATA", PropertyType.nameFromValue(p.getType()));
                if (p.isMultiValue()) {
                    attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "multiple", "sv:multiple", "CDATA", "true");
                }
                this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property", attrs);
                for (String v : p.getStringValues()) {
                    this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value", DocViewSAXHandler.EMPTY_ATTRIBUTES);
                    this.handler.characters(v.toCharArray(), 0, v.length());
                    this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value");
                }
                this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property");
            }
        }
        catch (SAXException e) {
            throw new InvalidSerializedDataException("Invalid sysview", e);
        }
        if (this.rootName == null) {
            this.rootName = ni.getName();
        }
    }

    @Override
    public void endNode() throws RepositoryException {
        if (this.ignoreLevel > 0L) {
            --this.ignoreLevel;
            return;
        }
        try {
            this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node");
        }
        catch (SAXException e) {
            throw new InvalidSerializedDataException("Invalid sysview", e);
        }
    }

    public JcrSysViewTransformer excludeNode(Name name) {
        this.excludedNodeNames.add(name);
        return this;
    }
}

